/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;
import org.jdesktop.application.utils.SwingHelper;

public abstract class SingleFrameApplication
extends Application {
    private static final String INITIALIZATION_MARKER = "SingleFrameApplication.initRootPaneContainer";
    private static final Logger logger = Logger.getLogger(SingleFrameApplication.class.getName());
    private FrameView mainView = null;

    public final JFrame getMainFrame() {
        return this.getMainView().getFrame();
    }

    protected final void setMainFrame(JFrame mainFrame) {
        this.getMainView().setFrame(mainFrame);
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String name = window.getName();
        return name == null ? null : name + ".session.xml";
    }

    protected void configureWindow(Window root) {
        this.getContext().getResourceMap().injectComponents(root);
    }

    private void initRootPaneContainer(RootPaneContainer c2) {
        Window window;
        JFrame mainFrame;
        JRootPane rootPane = c2.getRootPane();
        if (rootPane.getClientProperty(INITIALIZATION_MARKER) != null) {
            return;
        }
        rootPane.putClientProperty(INITIALIZATION_MARKER, Boolean.TRUE);
        Container root = rootPane.getParent();
        if (root instanceof Window) {
            this.configureWindow((Window)root);
        }
        if (c2 == (mainFrame = this.getMainFrame())) {
            mainFrame.addWindowListener(new MainFrameListener());
            mainFrame.setDefaultCloseOperation(0);
        } else if (root instanceof Window) {
            window = (Window)root;
            window.addHierarchyListener(new SecondaryWindowListener());
        }
        if (root instanceof JFrame) {
            root.addComponentListener(new FrameBoundsListener());
        }
        if (root instanceof Window) {
            String filename;
            window = (Window)root;
            if (!root.isValid() || root.getWidth() == 0 || root.getHeight() == 0) {
                window.pack();
            }
            if ((filename = this.sessionFilename((Window)root)) != null) {
                try {
                    this.getContext().getSessionStorage().restore(root, filename);
                }
                catch (Exception e2) {
                    String msg = String.format("couldn't restore session [%s]", filename);
                    logger.log(Level.WARNING, msg, e2);
                }
            }
            Point defaultLocation = SwingHelper.defaultLocation(window);
            if (!window.isLocationByPlatform() && (double)root.getX() == defaultLocation.getX() && (double)root.getY() == defaultLocation.getY()) {
                Dimension screenSize = window.getToolkit().getScreenSize();
                Dimension windowSIze = window.getSize();
                if (screenSize.getWidth() / windowSIze.getWidth() > 1.25 && screenSize.getHeight() / windowSIze.getHeight() > 1.25) {
                    Window owner = window.getOwner();
                    if (owner == null) {
                        owner = window != mainFrame ? mainFrame : null;
                    }
                    window.setLocationRelativeTo(owner);
                }
            }
        }
    }

    protected void show(JComponent c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame f2 = this.getMainFrame();
        f2.getContentPane().add((Component)c2, "Center");
        this.initRootPaneContainer(f2);
        f2.setVisible(true);
    }

    public void show(JDialog c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.initRootPaneContainer(c2);
        c2.setVisible(true);
    }

    public void show(JFrame c2) {
        if (c2 == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.initRootPaneContainer(c2);
        c2.setVisible(true);
    }

    private void saveSession(Window window) {
        String filename = this.sessionFilename(window);
        if (filename != null) {
            try {
                this.getContext().getSessionStorage().save(window, filename);
            }
            catch (IOException e2) {
                logger.log(Level.WARNING, "couldn't save session", e2);
            }
        }
    }

    private boolean isVisibleWindow(Window w2) {
        return w2.isVisible() && (w2 instanceof JFrame || w2 instanceof JDialog || w2 instanceof JWindow);
    }

    private List<Window> getVisibleSecondaryWindows() {
        ArrayList<Window> rv = new ArrayList<Window>();
        for (Window window : Window.getWindows()) {
            if (!this.isVisibleWindow(window)) continue;
            rv.add(window);
        }
        return rv;
    }

    @Override
    protected void shutdown() {
        if (this.isReady()) {
            for (Window window : this.getVisibleSecondaryWindows()) {
                this.saveSession(window);
            }
        }
    }

    public FrameView getMainView() {
        if (this.mainView == null) {
            this.mainView = new FrameView(this);
        }
        return this.mainView;
    }

    @Override
    public void show(View view) {
        if (this.mainView == null && view instanceof FrameView) {
            this.mainView = (FrameView)view;
        }
        RootPaneContainer c2 = (RootPaneContainer)((Object)view.getRootPane().getParent());
        this.initRootPaneContainer(c2);
        ((Window)((Object)c2)).setVisible(true);
    }

    @Override
    protected void end() {
        JFrame mainFrame = this.getMainFrame();
        if (mainFrame != null || mainFrame.isDisplayable()) {
            mainFrame.setVisible(false);
            mainFrame.dispose();
        }
        super.end();
    }

    private static class FrameBoundsListener
    implements ComponentListener {
        private FrameBoundsListener() {
        }

        private void maybeSaveFrameSize(ComponentEvent e2) {
            JFrame f2;
            if (e2.getComponent() instanceof JFrame && ((f2 = (JFrame)e2.getComponent()).getExtendedState() & 6) == 0) {
                SwingHelper.putWindowNormalBounds(f2, f2.getBounds());
            }
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            this.maybeSaveFrameSize(e2);
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
        }

        @Override
        public void componentShown(ComponentEvent e2) {
        }
    }

    private class SecondaryWindowListener
    implements HierarchyListener {
        private SecondaryWindowListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e2) {
            Window secondaryWindow;
            if ((e2.getChangeFlags() & 4L) != 0L && e2.getSource() instanceof Window && !(secondaryWindow = (Window)e2.getSource()).isShowing()) {
                SingleFrameApplication.this.saveSession(secondaryWindow);
            }
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e2) {
            SingleFrameApplication.this.exit(e2);
        }
    }
}

