/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.DefaultInputBlocker;
import org.jdesktop.application.MnemonicText;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

public class ApplicationAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ApplicationAction.class.getName());
    private final ApplicationActionMap appAM;
    private final ResourceMap resourceMap;
    private final String actionName;
    private final Method actionMethod;
    private final String enabledProperty;
    private final Method isEnabledMethod;
    private final Method setEnabledMethod;
    private final String selectedProperty;
    private final Method isSelectedMethod;
    private final Method setSelectedMethod;
    private String taskService;
    private final Task.BlockingScope block;
    private Action proxy = null;
    private Object proxySource = null;
    private PropertyChangeListener proxyPCL = null;
    private final boolean enabledNegated;

    public ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String baseName, Method actionMethod, String enabledProperty, boolean enabledNegated, String selectedProperty, String taskService, Task.BlockingScope block) {
        if (appAM == null) {
            throw new IllegalArgumentException("null appAM");
        }
        if (baseName == null) {
            throw new IllegalArgumentException("null baseName");
        }
        this.appAM = appAM;
        this.resourceMap = resourceMap;
        this.actionName = baseName;
        this.actionMethod = actionMethod;
        this.enabledProperty = enabledProperty;
        this.enabledNegated = enabledNegated;
        this.selectedProperty = selectedProperty;
        this.taskService = taskService;
        this.block = block;
        if (enabledProperty != null) {
            this.setEnabledMethod = this.propertySetMethod(this.enabledProperty, Boolean.TYPE);
            this.isEnabledMethod = this.propertyGetMethod(this.enabledProperty);
            if (this.isEnabledMethod == null) {
                throw this.newNoSuchPropertyException(this.enabledProperty);
            }
        } else {
            this.isEnabledMethod = null;
            this.setEnabledMethod = null;
        }
        if (selectedProperty != null) {
            this.setSelectedMethod = this.propertySetMethod(selectedProperty, Boolean.TYPE);
            this.isSelectedMethod = this.propertyGetMethod(selectedProperty);
            if (this.isSelectedMethod == null) {
                throw this.newNoSuchPropertyException(selectedProperty);
            }
            super.putValue("SwingSelectedKey", this.invokeBooleanMethod(appAM.getActionsObject(), this.isSelectedMethod));
        } else {
            this.isSelectedMethod = null;
            this.setSelectedMethod = null;
        }
        if (resourceMap != null) {
            this.initActionProperties(resourceMap, baseName);
        }
    }

    ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String actionName) {
        this(appAM, resourceMap, actionName, null, null, false, null, "default", Task.BlockingScope.NONE);
    }

    private IllegalArgumentException newNoSuchPropertyException(String propertyName) {
        String actionsClassName = this.appAM.getActionsClass().getName();
        String msg = String.format("no property named %s in %s", propertyName, actionsClassName);
        return new IllegalArgumentException(msg);
    }

    String getEnabledProperty() {
        return this.enabledProperty;
    }

    String getSelectedProperty() {
        return this.selectedProperty;
    }

    public Action getProxy() {
        return this.proxy;
    }

    public void setProxy(Action proxy) {
        Action oldProxy = this.proxy;
        this.proxy = proxy;
        if (oldProxy != null) {
            oldProxy.removePropertyChangeListener(this.proxyPCL);
            this.proxyPCL = null;
        }
        if (this.proxy != null) {
            this.updateProxyProperties();
            this.proxyPCL = new ProxyPCL();
            proxy.addPropertyChangeListener(this.proxyPCL);
        } else if (oldProxy != null) {
            this.setEnabled(false);
            this.setSelected(false);
        }
        this.firePropertyChange("proxy", oldProxy, this.proxy);
    }

    public Object getProxySource() {
        return this.proxySource;
    }

    public void setProxySource(Object source) {
        Object oldValue = this.proxySource;
        this.proxySource = source;
        this.firePropertyChange("proxySource", oldValue, this.proxySource);
    }

    private void maybePutDescriptionValue(String key, Action proxy) {
        Object s2 = proxy.getValue(key);
        if (s2 instanceof String) {
            this.putValue(key, s2);
        }
    }

    private void updateProxyProperties() {
        Action proxy = this.getProxy();
        if (proxy != null) {
            this.setEnabled(proxy.isEnabled());
            Object s2 = proxy.getValue("SwingSelectedKey");
            this.setSelected(s2 instanceof Boolean && (Boolean)s2 != false);
            this.maybePutDescriptionValue("ShortDescription", proxy);
            this.maybePutDescriptionValue("LongDescription", proxy);
        }
    }

    private void initActionProperties(ResourceMap resourceMap, String baseName) {
        String shortDescription;
        Icon largeIcon;
        Icon smallIcon;
        Icon icon;
        KeyStroke key;
        Integer index;
        Integer mnemonic;
        boolean iconOrNameSpecified = false;
        String text = resourceMap.getString(baseName + ".Action.text", new Object[0]);
        if (text != null) {
            MnemonicText.configure(this, text);
            iconOrNameSpecified = true;
        }
        if ((mnemonic = resourceMap.getKeyCode(baseName + ".Action.mnemonic")) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((index = resourceMap.getInteger(baseName + ".Action.displayedMnemonicIndex")) != null) {
            this.putValue("SwingDisplayedMnemonicIndexKey", index);
        }
        if ((key = resourceMap.getKeyStroke(baseName + ".Action.accelerator")) != null) {
            this.putValue("AcceleratorKey", key);
        }
        if ((icon = resourceMap.getIcon(baseName + ".Action.icon")) != null) {
            this.putValue("SmallIcon", icon);
            this.putValue("SwingLargeIconKey", icon);
            iconOrNameSpecified = true;
        }
        if ((smallIcon = resourceMap.getIcon(baseName + ".Action.smallIcon")) != null) {
            this.putValue("SmallIcon", smallIcon);
            iconOrNameSpecified = true;
        }
        if ((largeIcon = resourceMap.getIcon(baseName + ".Action.largeIcon")) != null) {
            this.putValue("SwingLargeIconKey", largeIcon);
            iconOrNameSpecified = true;
        }
        if ((shortDescription = resourceMap.getString(baseName + ".Action.shortDescription", new Object[0])) != null && !shortDescription.isEmpty()) {
            this.putValue("ShortDescription", resourceMap.getString(baseName + ".Action.shortDescription", new Object[0]));
        }
        this.putValue("LongDescription", resourceMap.getString(baseName + ".Action.longDescription", new Object[0]));
        this.putValue("ActionCommandKey", resourceMap.getString(baseName + ".Action.command", new Object[0]));
        if (!iconOrNameSpecified) {
            this.putValue("Name", this.actionName);
        }
    }

    private String propertyMethodName(String prefix, String propertyName) {
        return prefix + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
    }

    private Method propertyGetMethod(String propertyName) {
        String[] getMethodNames = new String[]{this.propertyMethodName("is", propertyName), this.propertyMethodName("get", propertyName)};
        Class actionsClass = this.appAM.getActionsClass();
        for (String name : getMethodNames) {
            try {
                return actionsClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return null;
    }

    private Method propertySetMethod(String propertyName, Class type) {
        Class actionsClass = this.appAM.getActionsClass();
        try {
            return actionsClass.getMethod(this.propertyMethodName("set", propertyName), type);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    public String getName() {
        return this.actionName;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    protected Object getActionArgument(Class pType, String pKey, ActionEvent actionEvent) {
        Object argument = null;
        if (pType == ActionEvent.class) {
            argument = actionEvent;
        } else if (pType == Action.class) {
            argument = this;
        } else if (pType == ActionMap.class) {
            argument = this.appAM;
        } else if (pType == ResourceMap.class) {
            argument = this.resourceMap;
        } else if (pType == ApplicationContext.class) {
            argument = this.appAM.getContext();
        } else if (pType == Application.class) {
            argument = this.appAM.getContext().getApplication();
        } else {
            IllegalArgumentException e2 = new IllegalArgumentException("unrecognized @Action method parameter");
            this.actionFailed(e2);
        }
        return argument;
    }

    private Task.InputBlocker createInputBlocker(Task task, ActionEvent event) {
        Object target = event.getSource();
        if (this.block == Task.BlockingScope.ACTION) {
            target = this;
        }
        return new DefaultInputBlocker(task, this.block, target, this);
    }

    private void noProxyActionPerformed(ActionEvent actionEvent) {
        Object taskObject = null;
        Annotation[][] allPAnnotations = this.actionMethod.getParameterAnnotations();
        Class<?>[] pTypes = this.actionMethod.getParameterTypes();
        Object[] arguments = new Object[pTypes.length];
        for (int i2 = 0; i2 < pTypes.length; ++i2) {
            String pKey = null;
            for (Annotation pAnnotation : allPAnnotations[i2]) {
                if (!(pAnnotation instanceof Action.Parameter)) continue;
                pKey = ((Action.Parameter)pAnnotation).value();
                break;
            }
            arguments[i2] = this.getActionArgument(pTypes[i2], pKey, actionEvent);
        }
        try {
            Object target = this.appAM.getActionsObject();
            taskObject = this.actionMethod.invoke(target, arguments);
        }
        catch (Exception e2) {
            this.actionFailed(e2);
        }
        if (taskObject instanceof Task) {
            ApplicationContext ctx;
            TaskService ts;
            Task task = (Task)taskObject;
            if (task.getInputBlocker() == null) {
                task.setInputBlocker(this.createInputBlocker(task, actionEvent));
            }
            if ((ts = (ctx = this.appAM.getContext()).getTaskService(this.taskService)) != null) {
                ts.execute(task);
            } else {
                this.actionFailed(new IllegalArgumentException("Task Service [" + this.taskService + "] does not exist."));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Action proxy = this.getProxy();
        if (proxy != null) {
            actionEvent.setSource(this.getProxySource());
            proxy.actionPerformed(actionEvent);
        } else if (this.actionMethod != null) {
            this.noProxyActionPerformed(actionEvent);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.getProxy() != null || this.isEnabledMethod == null) {
            return super.isEnabled();
        }
        try {
            boolean b2 = (Boolean)this.isEnabledMethod.invoke(this.appAM.getActionsObject(), new Object[0]);
            return this.enabledNegated ^ b2;
        }
        catch (Exception e2) {
            throw this.newInvokeError(this.isEnabledMethod, e2, new Object[0]);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getProxy() != null || this.setEnabledMethod == null) {
            super.setEnabled(enabled);
        } else {
            try {
                this.setEnabledMethod.invoke(this.appAM.getActionsObject(), this.enabledNegated ^ enabled);
            }
            catch (Exception e2) {
                throw this.newInvokeError(this.setEnabledMethod, e2, enabled);
            }
        }
    }

    public boolean isSelected() {
        if (this.getProxy() != null || this.isSelectedMethod == null) {
            Object v2 = this.getValue("SwingSelectedKey");
            return v2 instanceof Boolean && (Boolean)v2 != false;
        }
        return this.invokeBooleanMethod(this.appAM.getActionsObject(), this.isSelectedMethod);
    }

    private Boolean invokeBooleanMethod(Object obj, Method method) {
        try {
            Object b2 = method.invoke(obj, new Object[0]);
            return (Boolean)b2;
        }
        catch (Exception e2) {
            throw this.newInvokeError(method, e2, new Object[0]);
        }
    }

    public void setSelected(boolean selected) {
        if (this.getProxy() != null || this.setSelectedMethod == null) {
            super.putValue("SwingSelectedKey", selected);
        } else {
            try {
                super.putValue("SwingSelectedKey", selected);
                if (selected != this.isSelected()) {
                    this.setSelectedMethod.invoke(this.appAM.getActionsObject(), selected);
                }
            }
            catch (Exception e2) {
                throw this.newInvokeError(this.setSelectedMethod, e2, selected);
            }
        }
    }

    @Override
    public void putValue(String key, Object value) {
        if ("SwingSelectedKey".equals(key) && value instanceof Boolean) {
            this.setSelected((Boolean)value);
        } else {
            super.putValue(key, value);
        }
    }

    private Error newInvokeError(Method m2, Exception e2, Object ... args) {
        StringBuilder argsString = new StringBuilder(args.length == 0 ? "" : args[0].toString());
        for (int i2 = 1; i2 < args.length; ++i2) {
            argsString.append(", ").append(args[i2].toString());
        }
        String actionsClassName = this.appAM.getActionsObject().getClass().getName();
        String msg = String.format("%s.%s(%s) failed", actionsClassName, m2, argsString.toString());
        return new Error(msg, e2);
    }

    void forwardPropertyChangeEvent(PropertyChangeEvent e2, String actionPropertyName) {
        if ("selected".equals(actionPropertyName) && e2.getNewValue() instanceof Boolean) {
            this.putValue("SwingSelectedKey", e2.getNewValue());
        }
        this.firePropertyChange(actionPropertyName, e2.getOldValue(), e2.getNewValue());
    }

    private void actionFailed(Exception e2) {
        throw new Error(e2);
    }

    public String toString() {
        Object nameValue;
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.getClass().getName());
        sb2.append(" ");
        boolean enabled = this.isEnabled();
        if (!enabled) {
            sb2.append("(");
        }
        sb2.append(this.getName());
        Object selectedValue = this.getValue("SwingSelectedKey");
        if (selectedValue instanceof Boolean && ((Boolean)selectedValue).booleanValue()) {
            sb2.append("+");
        }
        if (!enabled) {
            sb2.append(")");
        }
        if ((nameValue = this.getValue("Name")) instanceof String) {
            sb2.append(" \"");
            sb2.append((String)nameValue);
            sb2.append("\"");
        }
        this.proxy = this.getProxy();
        if (this.proxy != null) {
            sb2.append(" Proxy for: ");
            sb2.append(this.proxy.toString());
        }
        return sb2.toString();
    }

    private class ProxyPCL
    implements PropertyChangeListener {
        private ProxyPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName == null || "enabled".equals(propertyName) || "selected".equals(propertyName) || "ShortDescription".equals(propertyName) || "LongDescription".equals(propertyName)) {
                ApplicationAction.this.updateProxyProperties();
            }
        }
    }
}

