/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.validators;

import com.opencsv.exceptions.CsvValidationException;
import com.opencsv.validators.RowValidator;
import java.util.ArrayList;
import java.util.List;

public class RowValidatorAggregator {
    private static final int CAPACITY = 256;
    private List<RowValidator> validators = new ArrayList<RowValidator>();

    public void addValidator(RowValidator validator) {
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public boolean isValid(String[] row) {
        for (RowValidator validator : this.validators) {
            if (validator.isValid(row)) continue;
            return false;
        }
        return true;
    }

    public void validate(String[] row) throws CsvValidationException {
        StringBuilder combinedExceptionMessage = new StringBuilder(256);
        for (RowValidator validator : this.validators) {
            try {
                validator.validate(row);
            }
            catch (CsvValidationException ex) {
                combinedExceptionMessage.append(ex.getMessage()).append("\n");
            }
        }
        if (combinedExceptionMessage.length() > 0) {
            throw new CsvValidationException(combinedExceptionMessage.toString());
        }
    }
}

