/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.stream.reader;

import java.io.BufferedReader;
import java.io.IOException;

public class LineReader {
    private final BufferedReader reader;
    private final boolean keepCarriageReturns;

    public LineReader(BufferedReader reader, boolean keepCarriageReturns) {
        this.reader = reader;
        this.keepCarriageReturns = keepCarriageReturns;
    }

    public String readLine() throws IOException {
        return this.keepCarriageReturns ? this.readUntilNewline() : this.reader.readLine();
    }

    private String readUntilNewline() throws IOException {
        StringBuilder sb2 = new StringBuilder(1024);
        int c2 = this.reader.read();
        while (c2 > -1 && c2 != 10) {
            sb2.append((char)c2);
            c2 = this.reader.read();
        }
        return sb2.length() > 0 ? sb2.toString() : null;
    }
}

