/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.BeanVerifier;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.OpencsvUtils;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvBeanIntrospectionException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import com.opencsv.exceptions.CsvValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ProcessCsvLine<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<? extends T> mapper;
    private final CsvToBeanFilter filter;
    private final List<BeanVerifier<T>> verifiers;
    private final String[] line;
    private final BlockingQueue<OrderedObject<T>> resultantBeanQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;

    public ProcessCsvLine(long lineNumber, MappingStrategy<? extends T> mapper, CsvToBeanFilter filter, List<BeanVerifier<T>> verifiers, String[] line, BlockingQueue<OrderedObject<T>> resultantBeanQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mapper = mapper;
        this.filter = filter;
        this.verifiers = ObjectUtils.defaultIfNull(new ArrayList<BeanVerifier<T>>(verifiers), Collections.emptyList());
        this.line = ArrayUtils.clone(line);
        this.resultantBeanQueue = resultantBeanQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            if (this.filter == null || this.filter.allowLine(this.line)) {
                T obj = this.processLine();
                ListIterator<BeanVerifier<T>> verifierList = this.verifiers.listIterator();
                boolean keep = true;
                while (keep && verifierList.hasNext()) {
                    keep = verifierList.next().verifyBean(obj);
                }
                if (keep) {
                    OpencsvUtils.queueRefuseToAcceptDefeat(this.resultantBeanQueue, new OrderedObject<T>(this.lineNumber, obj));
                }
            }
        }
        catch (CsvException e2) {
            e2.setLineNumber(this.lineNumber);
            e2.setLine(this.line);
            if (this.throwExceptions) {
                throw new RuntimeException(e2);
            }
            OpencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, e2));
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    private T processLine() throws CsvBeanIntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException, CsvValidationException {
        return this.mapper.populateNewBean(this.line);
    }
}

