/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.plaf.IAppScrollBarUI;
import com.jtechdev.widgets.ImageBasedJComponent;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class IAppWidgetFactory {
    private IAppWidgetFactory() {
    }

    public static JScrollPane createScrollPane(Component view) {
        return IAppWidgetFactory.createScrollPane(view, 20, 30);
    }

    public static JScrollPane createScrollPane(Component view, int verticalScrollBarPolicy, int horizontalScrollBarPolicy) {
        JScrollPane retVal = new JScrollPane(view, verticalScrollBarPolicy, horizontalScrollBarPolicy);
        IAppWidgetFactory.makeIAppScrollPane(retVal);
        return retVal;
    }

    public static JScrollPane makeIAppScrollPane(JScrollPane scrollPane) {
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        IAppWidgetFactory.installUIDelegates(scrollPane);
        scrollPane.setCorner("LOWER_RIGHT_CORNER", IAppWidgetFactory.createScrollPaneCorner());
        scrollPane.setCorner("LOWER_LEFT_CORNER", IAppWidgetFactory.createScrollPaneCornerLowerLeft());
        return scrollPane;
    }

    public static void setIAppScrollBarButtonsSeparate(boolean buttonsApart) {
        IAppScrollBarUI.setButtonsSeparate(buttonsApart);
    }

    private static void installUIDelegates(JScrollPane scrollPane) {
        scrollPane.getVerticalScrollBar().setUI(new IAppScrollBarUI());
        scrollPane.getHorizontalScrollBar().setUI(new IAppScrollBarUI());
    }

    public static JComponent createScrollPaneCorner() {
        return new ImageBasedJComponent(new ImageIcon(IAppWidgetFactory.class.getResource("/com/jtechdev/macwidgets/images/iapp_scrollpane_corner.png")).getImage());
    }

    public static JComponent createScrollPaneCornerLowerLeft() {
        return new ImageBasedJComponent(new ImageIcon(IAppWidgetFactory.class.getResource("/com/jtechdev/macwidgets/images/iapp_scrollpane_corner_left.png")).getImage());
    }
}

