/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public abstract class TransformFilter
extends AbstractBufferedImageOp {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    public static final int NEAREST_NEIGHBOUR = 0;
    public static final int BILINEAR = 1;
    protected int edgeAction = 0;
    protected int interpolation = 1;
    protected Rectangle transformedSpace;
    protected Rectangle originalSpace;

    public void setEdgeAction(int edgeAction) {
        this.edgeAction = edgeAction;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    protected abstract void transformInverse(int var1, int var2, float[] var3);

    protected void transformSpace(Rectangle rect) {
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int type = src.getType();
        WritableRaster srcRaster = src.getRaster();
        this.originalSpace = new Rectangle(0, 0, width, height);
        this.transformedSpace = new Rectangle(0, 0, width, height);
        this.transformSpace(this.transformedSpace);
        if (dst == null) {
            ColorModel dstCM = src.getColorModel();
            dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
        }
        WritableRaster dstRaster = dst.getRaster();
        int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
        if (this.interpolation == 0) {
            return this.filterPixelsNN(dst, width, height, inPixels, this.transformedSpace);
        }
        int srcWidth = width;
        int srcHeight = height;
        int srcWidth1 = width - 1;
        int srcHeight1 = height - 1;
        int outWidth = this.transformedSpace.width;
        int outHeight = this.transformedSpace.height;
        boolean index = false;
        int[] outPixels = new int[outWidth];
        int outX = this.transformedSpace.x;
        int outY = this.transformedSpace.y;
        float[] out = new float[2];
        for (int y2 = 0; y2 < outHeight; ++y2) {
            for (int x2 = 0; x2 < outWidth; ++x2) {
                int se;
                int sw;
                int ne;
                int nw;
                this.transformInverse(outX + x2, outY + y2, out);
                int srcX = (int)Math.floor(out[0]);
                int srcY = (int)Math.floor(out[1]);
                float xWeight = out[0] - (float)srcX;
                float yWeight = out[1] - (float)srcY;
                if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                    int i2 = srcWidth * srcY + srcX;
                    nw = inPixels[i2];
                    ne = inPixels[i2 + 1];
                    sw = inPixels[i2 + srcWidth];
                    se = inPixels[i2 + srcWidth + 1];
                } else {
                    nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                    ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                    sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                    se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                }
                outPixels[x2] = ImageMath.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
            }
            this.setRGB(dst, 0, y2, this.transformedSpace.width, 1, outPixels);
        }
        return dst;
    }

    private final int getPixel(int[] pixels, int x2, int y2, int width, int height) {
        if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height) {
            switch (this.edgeAction) {
                default: {
                    return 0;
                }
                case 2: {
                    return pixels[ImageMath.mod(y2, height) * width + ImageMath.mod(x2, width)];
                }
                case 1: 
            }
            return pixels[ImageMath.clamp(y2, 0, height - 1) * width + ImageMath.clamp(x2, 0, width - 1)];
        }
        return pixels[y2 * width + x2];
    }

    protected BufferedImage filterPixelsNN(BufferedImage dst, int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int srcWidth = width;
        int srcHeight = height;
        int outWidth = transformedSpace.width;
        int outHeight = transformedSpace.height;
        int[] outPixels = new int[outWidth];
        int outX = transformedSpace.x;
        int outY = transformedSpace.y;
        int[] rgb = new int[4];
        float[] out = new float[2];
        for (int y2 = 0; y2 < outHeight; ++y2) {
            for (int x2 = 0; x2 < outWidth; ++x2) {
                this.transformInverse(outX + x2, outY + y2, out);
                int srcX = (int)out[0];
                int srcY = (int)out[1];
                if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                    int p2;
                    switch (this.edgeAction) {
                        default: {
                            p2 = 0;
                            break;
                        }
                        case 2: {
                            p2 = inPixels[ImageMath.mod(srcY, srcHeight) * srcWidth + ImageMath.mod(srcX, srcWidth)];
                            break;
                        }
                        case 1: {
                            p2 = inPixels[ImageMath.clamp(srcY, 0, srcHeight - 1) * srcWidth + ImageMath.clamp(srcX, 0, srcWidth - 1)];
                        }
                    }
                    outPixels[x2] = p2;
                    continue;
                }
                int i2 = srcWidth * srcY + srcX;
                rgb[0] = inPixels[i2];
                outPixels[x2] = inPixels[i2];
            }
            this.setRGB(dst, 0, y2, transformedSpace.width, 1, outPixels);
        }
        return dst;
    }
}

