/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ArrayColormap;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PixelUtils;
import java.io.Serializable;

public class SplineColormap
extends ArrayColormap
implements Serializable {
    public int numKnots = 4;
    public int[] xKnots = new int[]{0, 0, 255, 255};
    public int[] yKnots = new int[]{-16777216, -16777216, -1, -1};

    public SplineColormap() {
        this.rebuildGradient();
    }

    public SplineColormap(int[] xKnots, int[] yKnots) {
        this.xKnots = xKnots;
        this.yKnots = yKnots;
        this.numKnots = xKnots.length;
        this.rebuildGradient();
    }

    public int getKnot(int n2) {
        return this.yKnots[n2];
    }

    public void setKnot(int n2, int color) {
        this.yKnots[n2] = color;
        this.rebuildGradient();
    }

    public void addKnot(int x2, int color) {
        int[] nx = new int[this.numKnots + 1];
        int[] ny = new int[this.numKnots + 1];
        System.arraycopy(this.xKnots, 0, nx, 0, this.numKnots);
        System.arraycopy(this.yKnots, 0, ny, 0, this.numKnots);
        this.xKnots = nx;
        this.yKnots = ny;
        this.xKnots[this.numKnots] = x2;
        this.yKnots[this.numKnots] = color;
        ++this.numKnots;
        this.sortKnots();
        this.rebuildGradient();
    }

    public void removeKnot(int n2) {
        if (this.numKnots <= 4) {
            return;
        }
        if (n2 < this.numKnots - 1) {
            System.arraycopy(this.xKnots, n2 + 1, this.xKnots, n2, this.numKnots - n2 - 1);
            System.arraycopy(this.yKnots, n2 + 1, this.yKnots, n2, this.numKnots - n2 - 1);
        }
        --this.numKnots;
        this.rebuildGradient();
    }

    public void setKnotPosition(int n2, int x2) {
        this.xKnots[n2] = PixelUtils.clamp(x2);
        this.sortKnots();
        this.rebuildGradient();
    }

    private void rebuildGradient() {
        this.xKnots[0] = -1;
        this.xKnots[this.numKnots - 1] = 256;
        this.yKnots[0] = this.yKnots[1];
        this.yKnots[this.numKnots - 1] = this.yKnots[this.numKnots - 2];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.map[i2] = ImageMath.colorSpline(i2, this.numKnots, this.xKnots, this.yKnots);
        }
    }

    private void sortKnots() {
        for (int i2 = 1; i2 < this.numKnots; ++i2) {
            for (int j2 = 1; j2 < i2; ++j2) {
                if (this.xKnots[i2] >= this.xKnots[j2]) continue;
                int t2 = this.xKnots[i2];
                this.xKnots[i2] = this.xKnots[j2];
                this.xKnots[j2] = t2;
                t2 = this.yKnots[i2];
                this.yKnots[i2] = this.yKnots[j2];
                this.yKnots[j2] = t2;
            }
        }
    }
}

