/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class SphereFilter
extends TransformFilter {
    static final long serialVersionUID = -8148404526162968279L;
    private float a = 0.0f;
    private float b = 0.0f;
    private float a2 = 0.0f;
    private float b2 = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float refractionIndex = 1.5f;
    private float icentreX;
    private float icentreY;

    public SphereFilter() {
        this.setEdgeAction(1);
        this.setRadius(100.0f);
    }

    public void setRefractionIndex(float refractionIndex) {
        this.refractionIndex = refractionIndex;
    }

    public float getRefractionIndex() {
        return this.refractionIndex;
    }

    public void setRadius(float r2) {
        this.a = r2;
        this.b = r2;
    }

    public float getRadius() {
        return this.a;
    }

    public void setCentreX(float centreX) {
        this.centreX = centreX;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float centreY) {
        this.centreY = centreY;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D centre) {
        this.centreX = (float)centre.getX();
        this.centreY = (float)centre.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        this.icentreX = (float)width * this.centreX;
        this.icentreY = (float)height * this.centreY;
        if (this.a == 0.0f) {
            this.a = width / 2;
        }
        if (this.b == 0.0f) {
            this.b = height / 2;
        }
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        return super.filter(src, dst);
    }

    protected void transformInverse(int x2, int y2, float[] out) {
        float dy = (float)y2 - this.icentreY;
        float y22 = dy * dy;
        float dx = (float)x2 - this.icentreX;
        float x22 = dx * dx;
        if (y22 >= this.b2 - this.b2 * x22 / this.a2) {
            out[0] = x2;
            out[1] = y2;
        } else {
            float rRefraction = 1.0f / this.refractionIndex;
            float z2 = (float)Math.sqrt((1.0f - x22 / this.a2 - y22 / this.b2) * (this.a * this.b));
            float z22 = z2 * z2;
            float xAngle = (float)Math.acos((double)dx / Math.sqrt(x22 + z22));
            float angle1 = 1.5707964f - xAngle;
            float angle2 = (float)Math.asin(Math.sin(angle1) * (double)rRefraction);
            angle2 = 1.5707964f - xAngle - angle2;
            out[0] = (float)x2 - (float)Math.tan(angle2) * z2;
            float yAngle = (float)Math.acos((double)dy / Math.sqrt(y22 + z22));
            angle1 = 1.5707964f - yAngle;
            angle2 = (float)Math.asin(Math.sin(angle1) * (double)rRefraction);
            angle2 = 1.5707964f - yAngle - angle2;
            out[1] = (float)y2 - (float)Math.tan(angle2) * z2;
        }
    }

    public String toString() {
        return "Distort/Sphere...";
    }
}

