/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public abstract class PointFilter
extends AbstractBufferedImageOp {
    protected boolean canFilterIndexColorModel = false;

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        int type = src.getType();
        WritableRaster srcRaster = src.getRaster();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        WritableRaster dstRaster = dst.getRaster();
        this.setDimensions(width, height);
        int[] inPixels = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            int x2;
            if (type == 2) {
                srcRaster.getDataElements(0, y2, width, 1, inPixels);
                for (x2 = 0; x2 < width; ++x2) {
                    inPixels[x2] = this.filterRGB(x2, y2, inPixels[x2]);
                }
                dstRaster.setDataElements(0, y2, width, 1, inPixels);
                continue;
            }
            src.getRGB(0, y2, width, 1, inPixels, 0, width);
            for (x2 = 0; x2 < width; ++x2) {
                inPixels[x2] = this.filterRGB(x2, y2, inPixels[x2]);
            }
            dst.setRGB(0, y2, width, 1, inPixels, 0, width);
        }
        return dst;
    }

    public void setDimensions(int width, int height) {
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

