/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public abstract class ImageUtils {
    public static final int SELECTED = -16777216;
    public static final int UNSELECTED = 0;
    public static BufferedImage backgroundImage = null;

    public static BufferedImage createImage(ImageProducer producer) {
        PixelGrabber pg = new PixelGrabber(producer, 0, 0, -1, -1, null, 0, 0);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Image fetch interrupted");
        }
        if ((pg.status() & 0x80) != 0) {
            throw new RuntimeException("Image fetch aborted");
        }
        if ((pg.status() & 0x40) != 0) {
            throw new RuntimeException("Image fetch error");
        }
        BufferedImage p2 = new BufferedImage(pg.getWidth(), pg.getHeight(), 2);
        p2.setRGB(0, 0, pg.getWidth(), pg.getHeight(), (int[])pg.getPixels(), 0, pg.getWidth());
        return p2;
    }

    public static BufferedImage convertImageToARGB(Image image) {
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 2) {
            return (BufferedImage)image;
        }
        BufferedImage p2 = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = p2.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return p2;
    }

    public static BufferedImage getSubimage(BufferedImage image, int x2, int y2, int w2, int h2) {
        BufferedImage newImage = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawRenderedImage(image, AffineTransform.getTranslateInstance(-x2, -y2));
        g2.dispose();
        return newImage;
    }

    public static BufferedImage cloneImage(BufferedImage image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = newImage.createGraphics();
        g2.drawRenderedImage(image, null);
        g2.dispose();
        return newImage;
    }

    public static void paintCheckedBackground(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (backgroundImage == null) {
            backgroundImage = new BufferedImage(64, 64, 2);
            Graphics2D bg = backgroundImage.createGraphics();
            for (int by = 0; by < 64; by += 8) {
                for (int bx = 0; bx < 64; bx += 8) {
                    bg.setColor(((bx ^ by) & 8) != 0 ? Color.lightGray : Color.white);
                    bg.fillRect(bx, by, 8, 8);
                }
            }
            bg.dispose();
        }
        if (backgroundImage != null) {
            Shape saveClip = g2.getClip();
            Rectangle r2 = g2.getClipBounds();
            if (r2 == null) {
                r2 = new Rectangle(c2.getSize());
            }
            r2 = r2.intersection(new Rectangle(x2, y2, width, height));
            g2.setClip(r2);
            int w2 = backgroundImage.getWidth();
            int h2 = backgroundImage.getHeight();
            if (w2 != -1 && h2 != -1) {
                int x1 = r2.x / w2 * w2;
                int y1 = r2.y / h2 * h2;
                int x22 = (r2.x + r2.width + w2 - 1) / w2 * w2;
                int y22 = (r2.y + r2.height + h2 - 1) / h2 * h2;
                for (y2 = y1; y2 < y22; y2 += h2) {
                    for (x2 = x1; x2 < x22; x2 += w2) {
                        g2.drawImage(backgroundImage, x2, y2, c2);
                    }
                }
            }
            g2.setClip(saveClip);
        }
    }

    public static Rectangle getSelectedBounds(BufferedImage p2) {
        int y1;
        int width = p2.getWidth();
        int height = p2.getHeight();
        int maxX = 0;
        int maxY = 0;
        int minX = width;
        int minY = height;
        boolean anySelected = false;
        int[] pixels = null;
        for (y1 = height - 1; y1 >= 0; --y1) {
            int x2;
            pixels = ImageUtils.getRGB(p2, 0, y1, width, 1, pixels);
            for (x2 = 0; x2 < minX; ++x2) {
                if ((pixels[x2] & 0xFF000000) == 0) continue;
                minX = x2;
                maxY = y1;
                anySelected = true;
                break;
            }
            for (x2 = width - 1; x2 >= maxX; --x2) {
                if ((pixels[x2] & 0xFF000000) == 0) continue;
                maxX = x2;
                maxY = y1;
                anySelected = true;
                break;
            }
            if (anySelected) break;
        }
        pixels = null;
        block3: for (int y2 = 0; y2 < y1; ++y2) {
            int x3;
            pixels = ImageUtils.getRGB(p2, 0, y2, width, 1, pixels);
            for (x3 = 0; x3 < minX; ++x3) {
                if ((pixels[x3] & 0xFF000000) == 0) continue;
                minX = x3;
                if (y2 < minY) {
                    minY = y2;
                }
                anySelected = true;
                break;
            }
            for (x3 = width - 1; x3 >= maxX; --x3) {
                if ((pixels[x3] & 0xFF000000) == 0) continue;
                maxX = x3;
                if (y2 < minY) {
                    minY = y2;
                }
                anySelected = true;
                continue block3;
            }
        }
        if (anySelected) {
            return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        }
        return null;
    }

    public static void composeThroughMask(Raster src, WritableRaster dst, Raster sel) {
        int x2 = src.getMinX();
        int y2 = src.getMinY();
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        int[] srcRGB = null;
        int[] selRGB = null;
        int[] dstRGB = null;
        for (int i2 = 0; i2 < h2; ++i2) {
            srcRGB = src.getPixels(x2, y2, w2, 1, srcRGB);
            selRGB = sel.getPixels(x2, y2, w2, 1, selRGB);
            dstRGB = dst.getPixels(x2, y2, w2, 1, dstRGB);
            int k2 = x2;
            for (int j2 = 0; j2 < w2; ++j2) {
                int sr = srcRGB[k2];
                int dir = dstRGB[k2];
                int sg = srcRGB[k2 + 1];
                int dig = dstRGB[k2 + 1];
                int sb2 = srcRGB[k2 + 2];
                int dib = dstRGB[k2 + 2];
                int sa = srcRGB[k2 + 3];
                int dia = dstRGB[k2 + 3];
                float a2 = (float)selRGB[k2 + 3] / 255.0f;
                float ac2 = 1.0f - a2;
                dstRGB[k2] = (int)(a2 * (float)sr + ac2 * (float)dir);
                dstRGB[k2 + 1] = (int)(a2 * (float)sg + ac2 * (float)dig);
                dstRGB[k2 + 2] = (int)(a2 * (float)sb2 + ac2 * (float)dib);
                dstRGB[k2 + 3] = (int)(a2 * (float)sa + ac2 * (float)dia);
                k2 += 4;
            }
            dst.setPixels(x2, y2, w2, 1, dstRGB);
            ++y2;
        }
    }

    public static int[] getRGB(BufferedImage image, int x2, int y2, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            return (int[])image.getRaster().getDataElements(x2, y2, width, height, pixels);
        }
        return image.getRGB(x2, y2, width, height, pixels, 0, width);
    }

    public static void setRGB(BufferedImage image, int x2, int y2, int width, int height, int[] pixels) {
        int type = image.getType();
        if (type == 2 || type == 1) {
            image.getRaster().setDataElements(x2, y2, width, height, pixels);
        } else {
            image.setRGB(x2, y2, width, height, pixels, 0, width);
        }
    }
}

