/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticSpinnerUI;
import com.jgoodies.looks.plastic.PlasticXPUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPSpinnerUI
extends PlasticSpinnerUI {
    private static final ExtBasicArrowButtonHandler NEXT_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler PREVIOUS_BUTTON_HANDLER = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticXPSpinnerUI();
    }

    protected Component createPreviousButton() {
        return new SpinnerXPArrowButton(5, PREVIOUS_BUTTON_HANDLER);
    }

    protected Component createNextButton() {
        return new SpinnerXPArrowButton(1, NEXT_BUTTON_HANDLER);
    }

    private static final class SpinnerXPArrowButton
    extends PlasticArrowButton {
        SpinnerXPArrowButton(int direction, ExtBasicArrowButtonHandler handler) {
            super(direction, UIManager.getInt("ScrollBar.width") - 1, false);
            this.addActionListener(handler);
            this.addMouseListener(handler);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected void paintNorth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset, boolean paintBottom) {
            if (!this.isFreeStanding) {
                ++height;
                g2.translate(0, -1);
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = 1 + (h2 + 1 - arrowHeight) / 2;
            int startX = w2 / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY + line, 2 * (line + 1), 1);
            }
            this.paintNorthBorder(g2, isEnabled, width, height, paintBottom);
            if (!this.isFreeStanding) {
                --height;
                g2.translate(0, 1);
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }

        private void paintNorthBorder(Graphics g2, boolean isEnabled, int w2, int h2, boolean paintBottom) {
            if (isEnabled) {
                boolean isPressed;
                boolean bl = isPressed = this.model.isPressed() && this.model.isArmed();
                if (isPressed) {
                    PlasticXPUtils.drawPressedButtonBorder(g2, 0, 1, w2 - 2, h2);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(g2, 0, 1, w2 - 2, h2);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(g2, 0, 1, w2 - 2, h2 + 1);
            }
            g2.setColor(isEnabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            g2.fillRect(0, 1, 1, 1);
            if (paintBottom) {
                g2.fillRect(0, h2 - 1, w2 - 1, 1);
            }
        }

        protected void paintSouth(Graphics g2, boolean leftToRight, boolean isEnabled, Color arrowColor, boolean isPressed, int width, int height, int w2, int h2, int arrowHeight, int arrowOffset) {
            if (!this.isFreeStanding) {
                ++height;
                if (!leftToRight) {
                    ++width;
                    g2.translate(-1, 0);
                } else {
                    width += 2;
                }
            }
            g2.setColor(arrowColor);
            int startY = (h2 + 0 - arrowHeight) / 2 + arrowHeight - 2;
            int startX = w2 / 2;
            for (int line = 0; line < arrowHeight; ++line) {
                g2.fillRect(startX - line - arrowOffset, startY - line, 2 * (line + 1), 1);
            }
            this.paintSouthBorder(g2, isEnabled, width, height);
            if (!this.isFreeStanding) {
                --height;
                if (!leftToRight) {
                    --width;
                    g2.translate(1, 0);
                } else {
                    width -= 2;
                }
            }
        }

        private void paintSouthBorder(Graphics g2, boolean isEnabled, int w2, int h2) {
            if (isEnabled) {
                boolean isPressed;
                boolean bl = isPressed = this.model.isPressed() && this.model.isArmed();
                if (isPressed) {
                    PlasticXPUtils.drawPressedButtonBorder(g2, 0, -2, w2 - 2, h2 + 1);
                } else {
                    PlasticXPUtils.drawPlainButtonBorder(g2, 0, -2, w2 - 2, h2 + 1);
                }
            } else {
                PlasticXPUtils.drawDisabledButtonBorder(g2, 0, -2, w2 - 2, h2 + 1);
            }
            g2.setColor(isEnabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlShadow());
            g2.fillRect(0, h2 - 2, 1, 1);
        }
    }
}

