/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    public void focusGained(FocusEvent e2) {
        JTextComponent c2;
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if ((c2 = this.getComponent()).isEnabled() && this.isKeyboardFocusEvent) {
            if (c2 instanceof JFormattedTextField) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        PlasticFieldCaret.super.setDot(0);
                        PlasticFieldCaret.super.moveDot(c2.getDocument().getLength());
                    }
                });
            } else {
                super.setDot(0);
                super.moveDot(c2.getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent e2) {
        super.focusLost(e2);
        if (!e2.isTemporary()) {
            this.isKeyboardFocusEvent = true;
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (SwingUtilities.isLeftMouseButton(e2) || e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e2);
    }

    public void mouseReleased(MouseEvent e2) {
        super.mouseReleased(e2);
        if (e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

