/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class WindowsCornerIcon
implements Icon {
    private static final Color THREE_D_EFFECT_COLOR = new Color(255, 255, 255);
    private static final Color SQUARE_COLOR_LEFT = new Color(184, 180, 163);
    private static final Color SQUARE_COLOR_TOP_RIGHT = new Color(184, 180, 161);
    private static final Color SQUARE_COLOR_BOTTOM_RIGHT = new Color(184, 181, 161);
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;
    private Corner corner = Corner.LOWER_RIGHT;

    public WindowsCornerIcon(Corner corner) {
        if (corner == null) {
            throw new IllegalArgumentException("corner can not be NULL");
        }
        this.corner = corner;
    }

    public WindowsCornerIcon() {
    }

    @Override
    public int getIconHeight() {
        return 12;
    }

    @Override
    public int getIconWidth() {
        return 12;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        int firstRow = y2;
        int firstColumn = x2;
        int rowDiff = 4;
        int columnDiff = 4;
        int secondRow = firstRow + rowDiff;
        int secondColumn = firstColumn + columnDiff;
        int thirdRow = secondRow + rowDiff;
        int thirdColumn = secondColumn + columnDiff;
        switch (this.corner) {
            case LOWER_RIGHT: {
                this.draw3dSquare(g2, firstColumn + 1, thirdRow + 1);
                this.draw3dSquare(g2, secondColumn + 1, secondRow + 1);
                this.draw3dSquare(g2, secondColumn + 1, thirdRow + 1);
                this.draw3dSquare(g2, thirdColumn + 1, firstRow + 1);
                this.draw3dSquare(g2, thirdColumn + 1, secondRow + 1);
                this.draw3dSquare(g2, thirdColumn + 1, thirdRow + 1);
                this.drawSquare(g2, firstColumn, thirdRow);
                this.drawSquare(g2, secondColumn, secondRow);
                this.drawSquare(g2, secondColumn, thirdRow);
                this.drawSquare(g2, thirdColumn, firstRow);
                this.drawSquare(g2, thirdColumn, secondRow);
                this.drawSquare(g2, thirdColumn, thirdRow);
                break;
            }
            case UPPER_LEFT: {
                this.draw3dSquare(g2, firstColumn + 1, firstRow + 1);
                this.draw3dSquare(g2, firstColumn + 1, secondRow + 1);
                this.draw3dSquare(g2, firstColumn + 1, thirdRow + 1);
                this.draw3dSquare(g2, secondColumn + 1, firstRow + 1);
                this.draw3dSquare(g2, secondColumn + 1, secondRow + 1);
                this.draw3dSquare(g2, thirdColumn + 1, firstRow + 1);
                this.drawSquare(g2, firstColumn, firstRow);
                this.drawSquare(g2, firstColumn, secondRow);
                this.drawSquare(g2, firstColumn, thirdRow);
                this.drawSquare(g2, secondColumn, firstRow);
                this.drawSquare(g2, secondColumn, secondRow);
                this.drawSquare(g2, thirdColumn, firstRow);
            }
        }
    }

    private void draw3dSquare(Graphics g2, int x2, int y2) {
        Color oldColor = g2.getColor();
        g2.setColor(THREE_D_EFFECT_COLOR);
        g2.fillRect(x2, y2, 2, 2);
        g2.setColor(oldColor);
    }

    private void drawSquare(Graphics g2, int x2, int y2) {
        Color oldColor = g2.getColor();
        g2.setColor(SQUARE_COLOR_LEFT);
        g2.drawLine(x2, y2, x2, y2 + 1);
        g2.setColor(SQUARE_COLOR_TOP_RIGHT);
        g2.drawLine(x2 + 1, y2, x2 + 1, y2);
        g2.setColor(SQUARE_COLOR_BOTTOM_RIGHT);
        g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + 1);
        g2.setColor(oldColor);
    }

    public static enum Corner {
        UPPER_LEFT,
        LOWER_RIGHT;

    }
}

