/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class TableUtils {
    private static final int DEFAULT_COLUMN_PADDING = 5;

    public static int autoResizeTable(JTable table, boolean includeColumnHeaderWidth) {
        return TableUtils.autoResizeTable(table, includeColumnHeaderWidth, 5);
    }

    public static int autoResizeTable(JTable table, boolean includeColumnHeaderWidth, int columnPadding) {
        int columnCount = table.getColumnCount();
        int tableWidth = 0;
        Dimension cellSpacing = table.getIntercellSpacing();
        if (columnCount > 0) {
            int[] columnWidth = new int[columnCount];
            for (int i2 = 0; i2 < columnCount; ++i2) {
                columnWidth[i2] = TableUtils.getMaxColumnWidth(table, i2, true, columnPadding);
                tableWidth += columnWidth[i2];
            }
            JTableHeader tableHeader = table.getTableHeader();
            Dimension headerDim = tableHeader.getPreferredSize();
            headerDim.width = tableWidth += (columnCount - 1) * cellSpacing.width;
            tableHeader.setPreferredSize(headerDim);
            Dimension interCellSpacing = table.getIntercellSpacing();
            Dimension dim = new Dimension();
            int rowHeight = table.getRowHeight();
            if (rowHeight == 0) {
                rowHeight = 16;
            }
            dim.height = headerDim.height + (rowHeight + interCellSpacing.height) * table.getRowCount();
            dim.width = tableWidth;
            TableColumnModel tableColumnModel = table.getColumnModel();
            for (int i3 = 0; i3 < columnCount; ++i3) {
                TableColumn tableColumn = tableColumnModel.getColumn(i3);
                tableColumn.setPreferredWidth(columnWidth[i3]);
            }
            table.invalidate();
            table.doLayout();
            table.repaint();
        }
        return tableWidth;
    }

    private static int getMaxColumnWidth(JTable table, int columnIndex, boolean includeColumnHeaderWidth, int columnPadding) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        Component comp = null;
        int maxWidth = 0;
        if (includeColumnHeaderWidth) {
            FontMetrics fontMetrics;
            Font font;
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer != null) {
                comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, columnIndex);
                if (comp instanceof JTextComponent) {
                    JTextComponent jtextComp = (JTextComponent)comp;
                    String text = jtextComp.getText();
                    font = jtextComp.getFont();
                    fontMetrics = jtextComp.getFontMetrics(font);
                    maxWidth = SwingUtilities.computeStringWidth(fontMetrics, text);
                } else {
                    maxWidth = comp.getPreferredSize().width;
                }
            } else {
                try {
                    String headerText = (String)column.getHeaderValue();
                    JLabel defaultLabel = new JLabel(headerText);
                    font = defaultLabel.getFont();
                    fontMetrics = defaultLabel.getFontMetrics(font);
                    maxWidth = SwingUtilities.computeStringWidth(fontMetrics, headerText);
                }
                catch (ClassCastException ce) {
                    maxWidth = 0;
                }
            }
        }
        int cellWidth = 0;
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            TableCellRenderer tableCellRenderer = table.getCellRenderer(i2, columnIndex);
            comp = tableCellRenderer.getTableCellRendererComponent(table, table.getValueAt(i2, columnIndex), false, false, i2, columnIndex);
            if (comp instanceof JTextComponent) {
                JTextComponent jtextComp = (JTextComponent)comp;
                String text = jtextComp.getText();
                Font font = jtextComp.getFont();
                FontMetrics fontMetrics = jtextComp.getFontMetrics(font);
                int textWidth = SwingUtilities.computeStringWidth(fontMetrics, text);
                maxWidth = Math.max(maxWidth, textWidth);
                continue;
            }
            cellWidth = comp.getPreferredSize().width;
            maxWidth = Math.max(maxWidth, cellWidth);
        }
        return maxWidth + columnPadding;
    }

    public static void repaintAfterValueChanged(JComponent comp, TreeTable table, TreeSelectionEvent e2) {
        TreePath[] paths = e2.getPaths();
        int y1 = Integer.MAX_VALUE;
        int y2 = Integer.MIN_VALUE;
        List<TreeTableNode> nodes = table.getTreeTableNodes();
        for (TreePath path : paths) {
            if (!table.isTreePathExpanded(path)) continue;
            int row = table.getRowForPath(path);
            TreeTableNode node = nodes.get(row);
            y1 = Math.min(y1, node.getY());
            y2 = Math.max(y2, node.getY() + node.getHeight());
        }
        comp.repaint(0, y1, comp.getWidth(), y2 - y1);
    }

    public static void ensureRowIsVisible(JTable table, int row) {
        Container parent;
        for (parent = table.getParent(); parent != null && !(parent instanceof JViewport); parent = parent.getParent()) {
        }
        Rectangle rec = null;
        int height = table.getRowHeight();
        if (parent == null) {
            rec = new Rectangle(0, row * height, 1, height);
        } else {
            rec = ((JViewport)parent).getViewRect();
            rec.y = row * height;
            rec.height = height;
        }
        table.scrollRectToVisible(rec);
    }
}

