/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class InfiniteProgressPanel
extends JComponent
implements MouseListener {
    protected Area[] ticker = null;
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected String text = "";
    protected int barsCount = 14;
    protected float fps = 15.0f;
    protected RenderingHints hints = null;

    public InfiniteProgressPanel() {
        this("");
    }

    public InfiniteProgressPanel(String text) {
        this(text, 14);
    }

    public InfiniteProgressPanel(String text, int barsCount) {
        this(text, barsCount, 0.7f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield) {
        this(text, barsCount, shield, 15.0f);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps) {
        this(text, barsCount, shield, fps, 300);
    }

    public InfiniteProgressPanel(String text, int barsCount, float shield, float fps, int rampDelay) {
        this.text = text;
        this.rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.fps = fps > 0.0f ? fps : 15.0f;
        this.barsCount = barsCount > 0 ? barsCount : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void start() {
        this.addMouseListener(this);
        this.setVisible(true);
        this.ticker = this.buildTicker();
        this.animation = new Thread(new Animator(true));
        this.animation.setName("InfiniteProgressPanelStartThread");
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.animation = new Thread(new Animator(false));
            this.animation.setName("InfiniteProgressPanelStopThread");
            this.animation.start();
        }
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.animation != null && this.animation.isAlive()) {
            Rectangle2D bounds;
            int width = this.getWidth();
            double maxY = 0.0;
            Graphics2D g22 = (Graphics2D)g2;
            g22.setRenderingHints(this.hints);
            g22.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i2 = 0; i2 < this.ticker.length; ++i2) {
                int channel = 224 - 128 / (i2 + 1);
                g22.setColor(new Color(channel, channel, channel, this.alphaLevel));
                g22.fill(this.ticker[i2]);
                bounds = this.ticker[i2].getBounds2D();
                if (!(bounds.getMaxY() > maxY)) continue;
                maxY = bounds.getMaxY();
            }
            if (this.text != null && this.text.length() > 0) {
                FontRenderContext context = g22.getFontRenderContext();
                TextLayout layout = new TextLayout(this.text, this.getFont(), context);
                bounds = layout.getBounds();
                g22.setColor(this.getForeground());
                layout.draw(g22, (float)((double)width - bounds.getWidth()) / 2.0f, (float)(maxY + (double)layout.getLeading() + (double)(2.0f * layout.getAscent())));
            }
        }
    }

    private Area[] buildTicker() {
        Area[] ticker = new Area[this.barsCount];
        Point2D.Double center = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double fixedAngle = Math.PI * 2 / (double)this.barsCount;
        for (double i2 = 0.0; i2 < (double)this.barsCount; i2 += 1.0) {
            Area primitive = this.buildPrimitive();
            AffineTransform toCenter = AffineTransform.getTranslateInstance(center.getX(), center.getY());
            AffineTransform toBorder = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform toCircle = AffineTransform.getRotateInstance(-i2 * fixedAngle, center.getX(), center.getY());
            AffineTransform toWheel = new AffineTransform();
            toWheel.concatenate(toCenter);
            toWheel.concatenate(toBorder);
            primitive.transform(toWheel);
            primitive.transform(toCircle);
            ticker[(int)i2] = primitive;
        }
        return ticker;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double body = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double head = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double tail = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area tick = new Area(body);
        tick.add(new Area(head));
        tick.add(new Area(tail));
        return tick;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    private class Animator
    implements Runnable {
        private boolean rampUp = true;

        protected Animator(boolean rampUp) {
            this.rampUp = rampUp;
        }

        @Override
        public void run() {
            Point2D.Double center = new Point2D.Double((double)InfiniteProgressPanel.this.getWidth() / 2.0, (double)InfiniteProgressPanel.this.getHeight() / 2.0);
            double fixedIncrement = Math.PI * 2 / (double)InfiniteProgressPanel.this.barsCount;
            AffineTransform toCircle = AffineTransform.getRotateInstance(fixedIncrement, center.getX(), center.getY());
            long start = System.currentTimeMillis();
            if (InfiniteProgressPanel.this.rampDelay == 0) {
                InfiniteProgressPanel.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            InfiniteProgressPanel.this.started = true;
            boolean inRamp = this.rampUp;
            while (!Thread.interrupted()) {
                block10: {
                    block9: {
                        if (!inRamp) {
                            for (int i2 = 0; i2 < InfiniteProgressPanel.this.ticker.length; ++i2) {
                                InfiniteProgressPanel.this.ticker[i2].transform(toCircle);
                            }
                        }
                        InfiniteProgressPanel.this.repaint();
                        if (!this.rampUp) break block9;
                        if (InfiniteProgressPanel.this.alphaLevel >= 255) break block10;
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel < 255) break block10;
                        InfiniteProgressPanel.this.alphaLevel = 255;
                        inRamp = false;
                        break block10;
                    }
                    if (InfiniteProgressPanel.this.alphaLevel > 0) {
                        InfiniteProgressPanel.this.alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)InfiniteProgressPanel.this.rampDelay);
                        if (InfiniteProgressPanel.this.alphaLevel <= 0) {
                            InfiniteProgressPanel.this.alphaLevel = 0;
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(inRamp ? 10L : (long)((int)(1000.0f / InfiniteProgressPanel.this.fps)));
                }
                catch (InterruptedException ie) {
                    break;
                }
                Thread.yield();
            }
            if (!this.rampUp) {
                InfiniteProgressPanel.this.started = false;
                InfiniteProgressPanel.this.repaint();
                InfiniteProgressPanel.this.setVisible(false);
                InfiniteProgressPanel.this.removeMouseListener(InfiniteProgressPanel.this);
            }
        }
    }
}

