/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.IColumnModel;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.treetable.ITreeTableHeaderMenuProvider;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.util.MenuCleaner;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DefaultTreeTableHeaderMenuProvider
extends JPopupMenu
implements ITreeTableHeaderMenuProvider {
    public DefaultTreeTableHeaderMenuProvider() {
        super(Messages.getString("DefaultTreeTableHeaderMenuProvider.MENU_TITLE"));
    }

    @Override
    public JPopupMenu getPopupMenu(TreeTableHeader header, MouseEvent e2, TreeTableColumn column) {
        final AbstractGanttChart ganttChart = header.getGanttChart();
        this.removeAll();
        JMenu columnsMenu = new JMenu(Messages.getString("DefaultTreeTableHeaderMenuProvider.COLUMNS"));
        columnsMenu.setIcon(IconRegistry.getIcon(IconId.TABLE));
        this.add(columnsMenu);
        this.fillColumnsMenu(columnsMenu, header.getGanttChart());
        this.add(new JSeparator());
        JMenuItem formatAllItem = new JMenuItem(Messages.getString("DefaultTreeTableHeaderMenuProvider.FORMAT_ALL_COLUMNS"));
        this.add(formatAllItem);
        final TreeTableHeader fHeader = header;
        formatAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ganttChart.optimizeColumnWidth();
            }
        });
        JMenuItem formatCurrentItem = new JMenuItem(Messages.getString("DefaultTreeTableHeaderMenuProvider.FORMAT_COLUMN"));
        formatCurrentItem.setEnabled(column != null);
        if (column != null) {
            int min = column.getMinimumWidth();
            int max = column.getMaximumWidth();
            int width = column.getWidth();
            if (min == width && max == width) {
                formatCurrentItem.setEnabled(false);
            }
        }
        this.add(formatCurrentItem);
        final int index = header.getColumnIndexAt(e2.getX());
        formatCurrentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ganttChart.optimizeColumnWidth(index);
            }
        });
        if (column != null && column.isSortable()) {
            this.add(new JSeparator());
            JMenuItem sortItem = new JMenuItem(Messages.getString("DefaultTreeTableHeaderMenuProvider.SORT_COLUMN"));
            this.add(sortItem);
            final TreeTableColumn fColumn = column;
            sortItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    fHeader.sortColumn(fColumn, true);
                }
            });
        }
        MenuCleaner.clean(this);
        return this;
    }

    private void fillColumnsMenu(JMenu columnsMenu, final AbstractGanttChart ganttChart) {
        LinkedList<TreeTableColumn> list = new LinkedList<TreeTableColumn>();
        IColumnModel model = ganttChart.getColumnModel();
        KeyColumn keyColumn = model.getKeyColumn();
        if (keyColumn != null) {
            list.add(keyColumn);
        }
        int count = model.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            list.add(model.getColumn(i2));
        }
        List<TreeTableColumn> available = ganttChart.getAvailableColumns();
        list.addAll(available);
        Collections.sort(list);
        for (TreeTableColumn col : list) {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem(col.getName());
            if (col instanceof KeyColumn) {
                item.setIcon(IconRegistry.getIcon(IconId.KEY_COLUMN));
            } else {
                item.setIcon(IconRegistry.getIcon(IconId.COLUMN));
            }
            columnsMenu.add(item);
            item.setSelected(!available.contains(col));
            final TreeTableColumn fCol = col;
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (item.isSelected()) {
                        if (fCol instanceof KeyColumn) {
                            ganttChart.getColumnModel().setKeyColumn((KeyColumn)fCol);
                            ganttChart.removeAvailableColumn(fCol);
                        } else {
                            ganttChart.removeAvailableColumn(fCol);
                            ganttChart.getColumnModel().addColumn(fCol);
                        }
                    } else if (fCol instanceof KeyColumn) {
                        ganttChart.getColumnModel().setKeyColumn(null);
                        ganttChart.addAvailableColumn(fCol);
                    } else {
                        ganttChart.getColumnModel().removeColumn(fCol);
                        ganttChart.addAvailableColumn(fCol);
                    }
                }
            });
        }
    }
}

