/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.action.dateline.SetChangeVisibleEndTimeZoomStrategyAction;
import com.dlsc.flexgantt.swing.action.dateline.SetChangeVisibleStartAndEndTimeZoomStrategyAction;
import com.dlsc.flexgantt.swing.action.dateline.ToggleZoomAnimation;
import com.dlsc.flexgantt.swing.action.dateline.ZoomInAction;
import com.dlsc.flexgantt.swing.action.dateline.ZoomOutAction;
import com.dlsc.flexgantt.swing.action.gantt.AllObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.EarliestObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.LatestObjectsAction;
import com.dlsc.flexgantt.swing.action.gantt.RedoActionLabeled;
import com.dlsc.flexgantt.swing.action.gantt.TimeNowAction;
import com.dlsc.flexgantt.swing.action.gantt.UndoActionLabeled;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.IDatelineMenuProvider;
import com.dlsc.flexgantt.swing.util.MenuCleaner;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class DefaultDatelineMenuProvider
extends JPopupMenu
implements IDatelineMenuProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultDatelineMenuProvider.class.getName());

    public DefaultDatelineMenuProvider() {
        super(Messages.getString("DefaultDatelineMenuProvider.MENU_TITLE"));
    }

    @Override
    public JPopupMenu getPopupMenu(Dateline dateline, MouseEvent e2, boolean major, long timePoint, ITimeSpan span) {
        this.removeAll();
        this.add(new JMenuItem(new TimeNowAction<AbstractGanttChart>(dateline.getTimeline().getGanttChart())));
        this.add(new JMenuItem(new EarliestObjectsAction<AbstractGanttChart>(dateline.getTimeline().getGanttChart())));
        this.add(new JMenuItem(new LatestObjectsAction<AbstractGanttChart>(dateline.getTimeline().getGanttChart())));
        this.add(new JSeparator());
        this.add(new JMenuItem(new ZoomInAction(dateline)));
        this.add(new JMenuItem(new ZoomOutAction(dateline)));
        this.add(new JMenuItem(new AllObjectsAction<AbstractGanttChart>(dateline.getTimeline().getGanttChart())));
        this.add(new JSeparator());
        this.add(new UndoActionLabeled<AbstractGanttChart>(dateline.getTimeline().getGanttChart()));
        this.add(new RedoActionLabeled<AbstractGanttChart>(dateline.getTimeline().getGanttChart()));
        this.add(new JSeparator());
        IDatelineModel model = dateline.getModel();
        this.createModelMenu(model, dateline);
        JMenu zoomMenu = new JMenu(Messages.getString("DefaultDatelineMenuProvider.ZOOM"));
        JCheckBoxMenuItem animItem = new JCheckBoxMenuItem(new ToggleZoomAnimation(dateline));
        animItem.setSelected(dateline.isAnimatingZoom());
        zoomMenu.add(animItem);
        zoomMenu.addSeparator();
        JRadioButtonMenuItem zoomIntoCenterItem = new JRadioButtonMenuItem(new SetChangeVisibleStartAndEndTimeZoomStrategyAction(dateline));
        JRadioButtonMenuItem keepStartTimeItem = new JRadioButtonMenuItem(new SetChangeVisibleEndTimeZoomStrategyAction(dateline));
        ButtonGroup strategyGroup = new ButtonGroup();
        strategyGroup.add(zoomIntoCenterItem);
        strategyGroup.add(keepStartTimeItem);
        zoomMenu.add(zoomIntoCenterItem);
        zoomMenu.add(keepStartTimeItem);
        if (dateline.getZoomStrategy().equals((Object)Dateline.ZoomStrategy.CHANGE_VISIBLE_START_AND_END_TIME)) {
            zoomIntoCenterItem.setSelected(true);
        } else {
            keepStartTimeItem.setSelected(true);
        }
        this.add(zoomMenu);
        MenuCleaner.clean(this);
        return this;
    }

    private void createModelMenu(final IDatelineModel model, Dateline dateline) {
        IPolicyProvider pp = dateline.getPolicyProvider();
        IZoomPolicy zp = pp.getPolicy(IZoomPolicy.class);
        JMenu subMenu = new JMenu(Messages.getString("DefaultDatelineMenuProvider.MENU_GRANULARITY"));
        ButtonGroup group = new ButtonGroup();
        Object current = model.getGranularity();
        int count = zp.getGranularityCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object granularity = zp.getGranularity(i2);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(granularity.getName(), current.equals(granularity));
            item.addActionListener(new ActionListener(){
                final /* synthetic */ IGranularity val$granularity;
                {
                    this.val$granularity = iGranularity;
                }

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        model.setGranularity(this.val$granularity);
                    }
                    catch (DatelineModelException ex) {
                        LOGGER.throwing(DefaultDatelineMenuProvider.class.getName(), "actionPerformed(", ex);
                    }
                }
            });
            subMenu.add(item);
            group.add(item);
        }
        if (subMenu.getItemCount() > 0) {
            this.add(subMenu);
        }
    }
}

