/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.swing.util.GradientBorder;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class Selector
extends JWindow
implements LayoutManager {
    private static boolean globalAnimationEnabled = true;
    private static int globalAnimationDuration = 400;
    private static boolean globalAutoHideEnabled = true;
    private Location location;
    private JComponent parentComponent;
    private JComponent contentComponent;
    private JLabel titleLabel;
    private JPanel headerPanel;
    private JPanel footerPanel;
    private JLabel closeSelectorLabel;
    private boolean animationEnabled = true;
    private Animator animator;
    private boolean autoHideEnabled = true;

    public Selector(String title, JComponent parentComponent, JComponent contentComponent, Location location) {
        super(SwingUtilities.getWindowAncestor(parentComponent));
        if (title == null) {
            throw new IllegalArgumentException("title can not be NULL");
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException("parent component can not be NULL");
        }
        JPanel contentPane = new JPanel();
        contentPane.setOpaque(false);
        contentPane.setBorder(new GradientBorder());
        this.setContentPane(contentPane);
        this.setLayout(this);
        this.parentComponent = parentComponent;
        this.location = location;
        this.headerPanel = new JPanel();
        this.headerPanel.setOpaque(true);
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.headerPanel.setBackground(Color.ORANGE);
        this.add(this.headerPanel);
        this.footerPanel = new JPanel();
        this.footerPanel.setOpaque(false);
        this.footerPanel.setLayout(new BorderLayout());
        this.footerPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add(this.footerPanel);
        this.titleLabel = new JLabel(title);
        this.titleLabel.setOpaque(false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setHorizontalAlignment(0);
        this.closeSelectorLabel = new JLabel(Messages.getString("Selector.CLOSE"));
        this.closeSelectorLabel.setForeground(Color.BLUE);
        this.closeSelectorLabel.setOpaque(false);
        this.closeSelectorLabel.setToolTipText(Messages.getString("Selector.CLOSE_TOOLTIP"));
        this.closeSelectorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                Selector.this.setVisible(false);
            }
        });
        this.closeSelectorLabel.setBorder(new Border(){
            private final Insets INSETS = new Insets(0, 0, 1, 0);

            @Override
            public Insets getBorderInsets(Component c2) {
                return this.INSETS;
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                g2.setColor(c2.getForeground());
                g2.drawLine(x2, y2 + height - 1, x2 + width - 1, y2 + height - 1);
            }
        });
        this.closeSelectorLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.headerPanel.add("Center", this.titleLabel);
        this.footerPanel.add("East", this.closeSelectorLabel);
        parentComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Selector.this.setVisible(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                Selector.this.setVisible(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Selector.this.setVisible(false);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e2) {
            }

            @Override
            public void windowLostFocus(WindowEvent e2) {
                if (globalAutoHideEnabled && Selector.this.autoHideEnabled) {
                    Selector.this.setVisible(false);
                }
            }
        });
        if (contentComponent != null) {
            this.setContentComponent(contentComponent);
        }
        this.pack();
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Selector.this.setVisible(false);
            }
        };
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        String actionKey = "exit-action";
        actionMap.put(actionKey, closeAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, actionKey);
    }

    public Selector(String title, JComponent parentComponent, Location location) {
        this(title, parentComponent, null, location);
    }

    public void setAutoHideEnabled(boolean enabled) {
        this.autoHideEnabled = enabled;
    }

    public boolean isAutoHideEnabled() {
        return this.autoHideEnabled;
    }

    public void setContentComponent(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("content component can not be NULL");
        }
        if (this.contentComponent != null) {
            this.remove(this.contentComponent);
        }
        this.contentComponent = comp;
        this.add(comp);
        this.pack();
    }

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    @Override
    public void setVisible(boolean b2) {
        String version = System.getProperty("java.specification.version");
        boolean doAnimate = false;
        if (version != null && Float.parseFloat(version) > 1.5f && this.parentComponent.isShowing() && this.isAnimationEnabled() && globalAnimationEnabled) {
            doAnimate = true;
        }
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
        if (b2) {
            if (doAnimate) {
                this.animator = new Animator(globalAnimationDuration, new ShowTimingTarget());
                this.animator.setAcceleration(0.5f);
                this.animator.setDeceleration(0.5f);
                this.animator.start();
            } else {
                Point loc = this.parentComponent.getLocationOnScreen();
                Dimension dim1 = this.parentComponent.getSize();
                Dimension dim2 = this.getSize();
                switch (this.location) {
                    case BELOW: {
                        this.setLocation(loc.x, loc.y + dim1.height);
                        break;
                    }
                    case ABOVE: {
                        this.setLocation(loc.x, loc.y - dim2.height);
                        break;
                    }
                    case LEFT: {
                        this.setLocation(loc.x - dim2.width, loc.y);
                        break;
                    }
                    case RIGHT: {
                        this.setLocation(loc.x + dim1.width, loc.y);
                    }
                }
                super.setVisible(true);
                this.requestFocusInWindow();
            }
        } else if (doAnimate) {
            this.animator = new Animator(globalAnimationDuration, new HideTimingTarget());
            this.animator.start();
        } else {
            super.setVisible(false);
        }
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationEnabled = enabled;
    }

    public JComponent getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.contentComponent != null) {
            Dimension dim = this.contentComponent.getPreferredSize();
            Dimension dim2 = this.headerPanel.getPreferredSize();
            Dimension dim3 = this.footerPanel.getPreferredSize();
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            switch (this.location) {
                case BELOW: {
                    int y2 = insets.top + size.height - dim.height - dim2.height - dim3.height;
                    this.headerPanel.setBounds(insets.left, y2, size.width, dim2.height);
                    y2 = (int)((double)y2 + dim2.getHeight());
                    this.contentComponent.setBounds(insets.left, y2, size.width, dim.height);
                    y2 = (int)((double)y2 + dim.getHeight());
                    this.footerPanel.setBounds(insets.left, y2, size.width, dim3.height);
                    break;
                }
                case ABOVE: {
                    this.headerPanel.setBounds(insets.left, insets.top, size.width, dim2.height);
                    int height = Math.max(dim.height, size.height - dim2.height - dim3.height);
                    this.contentComponent.setBounds(insets.left, insets.top + dim2.height, size.width, height);
                    this.footerPanel.setBounds(insets.left, insets.top + dim2.height + dim.height, size.width, dim3.height);
                    break;
                }
                case LEFT: {
                    int width = Math.max(dim.width, dim2.width);
                    width = Math.max(width, dim3.width);
                    this.headerPanel.setBounds(insets.left, insets.top, width, dim2.height);
                    this.contentComponent.setBounds(insets.left, insets.top + dim2.height, width, dim.height);
                    this.footerPanel.setBounds(insets.left, insets.top + dim2.height + dim.height, width, dim3.height);
                    break;
                }
                case RIGHT: {
                    int width = Math.max(dim.width, dim2.width);
                    width = Math.max(width, dim3.width);
                    int x2 = insets.left + size.width - width;
                    this.headerPanel.setBounds(x2, insets.top, width, dim2.height);
                    this.contentComponent.setBounds(x2, insets.top + dim2.height, width, size.height);
                    this.footerPanel.setBounds(x2, insets.top + dim2.height + dim.height, width, dim3.height);
                }
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        if (this.contentComponent != null) {
            Dimension dim = this.contentComponent.getMinimumSize();
            Dimension dim2 = this.headerPanel.getMinimumSize();
            dim.width = Math.max(dim.width, dim2.width);
            dim.height += dim2.height;
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        if (this.contentComponent != null) {
            Dimension dim = this.contentComponent.getPreferredSize();
            Dimension dim2 = this.headerPanel.getPreferredSize();
            Dimension dim3 = this.footerPanel.getPreferredSize();
            dim.width = Math.max(dim.width, dim2.width);
            dim.width = Math.max(dim.width, dim3.width);
            dim.height += dim2.height;
            dim.height += dim3.height;
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
        return new Dimension(0, 0);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public Location getSelectorLocation() {
        return this.location;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public static boolean isGlobalAnimationEnabled() {
        return globalAnimationEnabled;
    }

    public static void setGlobalAnimationEnabled(boolean enabled) {
        globalAnimationEnabled = enabled;
    }

    public static int getGlobalAnimationDuration() {
        return globalAnimationDuration;
    }

    public static void setGlobalAnimationDuration(int duration) {
        globalAnimationDuration = duration;
    }

    public static void setGlobalAutoHideEnabled(boolean enabled) {
        globalAutoHideEnabled = enabled;
    }

    public static boolean isGlobalAutoHideEnabled() {
        return globalAutoHideEnabled;
    }

    private Point adjustLocationToFitScreen(int xposition, int yposition) {
        Rectangle screenBounds;
        Insets screenInsets;
        GraphicsDevice[] gd2;
        Point p2 = new Point(xposition, yposition);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc2 = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice element : gd2 = ge.getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (element.getType() != 0 || !(dgc = element.getDefaultConfiguration()).getBounds().contains(p2)) continue;
            gc2 = dgc;
            break;
        }
        if (gc2 == null) {
            gc2 = this.parentComponent.getGraphicsConfiguration();
        }
        if (gc2 != null) {
            screenInsets = toolkit.getScreenInsets(gc2);
            screenBounds = gc2.getBounds();
        } else {
            screenInsets = new Insets(0, 0, 0, 0);
            screenBounds = new Rectangle(toolkit.getScreenSize());
        }
        int scrWidth = screenBounds.width - Math.abs(screenInsets.left + screenInsets.right);
        int scrHeight = screenBounds.height - Math.abs(screenInsets.top + screenInsets.bottom);
        Dimension size = this.getSize();
        if (p2.x + size.width > screenBounds.x + scrWidth) {
            p2.x = screenBounds.x + scrWidth - size.width;
        }
        if (p2.y + size.height > screenBounds.y + scrHeight) {
            p2.y = screenBounds.y + scrHeight - size.height;
        }
        if (p2.x < screenBounds.x) {
            p2.x = screenBounds.x;
        }
        if (p2.y < screenBounds.y) {
            p2.y = screenBounds.y;
        }
        return p2;
    }

    public JPanel getFooterPanel() {
        return this.footerPanel;
    }

    public JLabel getCloseSelectorLabel() {
        return this.closeSelectorLabel;
    }

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            globalAnimationEnabled = false;
        }
    }

    public static enum Location {
        ABOVE,
        BELOW,
        LEFT,
        RIGHT;

    }

    class ShowTimingTarget
    extends AbstractShowHideTimingTarget {
        ShowTimingTarget() {
        }

        @Override
        public void begin() {
            this.windowSize = Selector.this.getPreferredSize();
            Selector.super.setVisible(true);
        }

        @Override
        public void end() {
            Selector.this.requestFocusInWindow();
        }
    }

    class HideTimingTarget
    extends AbstractShowHideTimingTarget {
        HideTimingTarget() {
        }

        @Override
        public void begin() {
            this.windowSize = Selector.this.getSize();
        }

        @Override
        public void end() {
            Selector.super.setVisible(false);
        }

        @Override
        public void timingEvent(float fraction) {
            fraction = 1.0f - fraction;
            super.timingEvent(fraction);
        }
    }

    abstract class AbstractShowHideTimingTarget
    implements TimingTarget {
        protected Dimension windowSize;

        AbstractShowHideTimingTarget() {
        }

        @Override
        public void begin() {
        }

        @Override
        public void repeat() {
        }

        @Override
        public void timingEvent(float fraction) {
            int x2 = Selector.this.getLocation().x;
            int y2 = Selector.this.getLocation().y;
            int w2 = 0;
            int h2 = 0;
            switch (Selector.this.location) {
                case BELOW: {
                    x2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().x;
                    y2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().y + Selector.this.parentComponent.getHeight();
                    w2 = this.windowSize.width;
                    h2 = (int)((float)this.windowSize.height * fraction);
                    break;
                }
                case ABOVE: {
                    w2 = this.windowSize.width;
                    h2 = (int)((float)this.windowSize.height * fraction);
                    x2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().x;
                    y2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().y - h2;
                    break;
                }
                case LEFT: {
                    w2 = (int)((float)this.windowSize.width * fraction);
                    x2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().x - w2;
                    y2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().y;
                    h2 = this.windowSize.height;
                    break;
                }
                case RIGHT: {
                    w2 = (int)((float)this.windowSize.width * fraction);
                    x2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().x + Selector.this.parentComponent.getWidth();
                    y2 = ((Selector)Selector.this).parentComponent.getLocationOnScreen().y;
                    h2 = this.windowSize.height;
                }
            }
            Point adjusted = Selector.this.adjustLocationToFitScreen(x2, y2);
            Selector.this.setBounds(adjusted.x, adjusted.y, Math.max(1, w2), Math.max(1, h2));
            Selector.this.invalidate();
            Selector.this.validate();
        }
    }
}

