/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.paging.IPagingModel;
import com.dlsc.flexgantt.model.paging.IPagingModelListener;
import com.dlsc.flexgantt.model.paging.Page;
import com.dlsc.flexgantt.model.paging.PagingEvent;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class PagingSelector
extends Selector
implements PropertyChangeListener {
    private AbstractGanttChart ganttChart;
    private JList list;

    public PagingSelector(JComponent comp, AbstractGanttChart gc2) {
        super(Messages.getString("PagingSelector.TITLE"), comp, Selector.Location.ABOVE);
        this.ganttChart = gc2;
        IPagingModel pagingModel = gc2.getPagingModel();
        this.list = new JList(new PageListModel(pagingModel));
        this.list.setOpaque(false);
        this.list.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.list.setCellRenderer(new PagingListCellRenderer(pagingModel));
        this.list.setSelectionModel(new PageListSelectionModel(this.list));
        final IPagingModel fpm = pagingModel;
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                if (evt.getClickCount() == 1 && (index = PagingSelector.this.list.locationToIndex(evt.getPoint())) >= 0) {
                    Page page = (Page)PagingSelector.this.list.getModel().getElementAt(index);
                    fpm.setPage(page);
                    PagingSelector.this.setVisible(false);
                }
            }
        });
        this.ganttChart.addPropertyChangeListener(this);
        this.setContentComponent(this.list);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.ganttChart) && evt.getPropertyName().equals("pagingModel")) {
            IPagingModel oldModel = (IPagingModel)evt.getOldValue();
            IPagingModel newModel = (IPagingModel)evt.getNewValue();
            PageListModel listModel = (PageListModel)this.list.getModel();
            if (listModel != null) {
                oldModel.removePagingModelListener(listModel);
            }
            if (newModel != null) {
                this.list.setModel(new PageListModel(newModel));
                this.list.setCellRenderer(new PagingListCellRenderer(newModel));
                newModel.addPagingModelListener(listModel);
            }
        }
    }

    class PageListModel
    extends DefaultListModel
    implements IPagingModelListener {
        private IPagingModel pagingModel;

        public PageListModel(IPagingModel model) {
            this.pagingModel = model;
            this.pagingModel.addPagingModelListener(this);
        }

        @Override
        public int getSize() {
            if (this.pagingModel == null) {
                return 0;
            }
            return this.pagingModel.getPageCount();
        }

        @Override
        public Object getElementAt(int index) {
            if (this.pagingModel == null) {
                return null;
            }
            return this.pagingModel.getPage(index);
        }

        @Override
        public void pageChanged(PagingEvent evt) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        @Override
        public void pageWillChange(PagingEvent evt) {
        }
    }

    class PagingListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel label;
        private PageVisualizer visualizer;
        private IPagingModel pagingModel;
        private JRadioButton box;

        public PagingListCellRenderer(IPagingModel model) {
            this.pagingModel = model;
            this.setOpaque(false);
            this.setLayout(new BorderLayout(10, 10));
            this.box = new JRadioButton();
            this.add("West", this.box);
            this.label = new JLabel();
            this.add("Center", this.label);
            this.visualizer = new PageVisualizer();
            this.add("East", this.visualizer);
            this.box.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
            ITimeSpan totalSpan = TimeSpan.UNDEFINED;
            int count = this.pagingModel.getPageCount();
            for (int i2 = 0; i2 < count; ++i2) {
                totalSpan = totalSpan.union(this.pagingModel.getPage(i2).getTimeSpan());
            }
            Page page = (Page)value;
            this.visualizer.setTotalSpan(totalSpan);
            this.visualizer.setSpan(page.getTimeSpan());
            this.visualizer.setSelected(selected);
            this.label.setText(page.getName());
            this.box.setSelected(selected);
            return this;
        }
    }

    class PageListSelectionModel
    extends DefaultListSelectionModel {
        private JList list;

        public PageListSelectionModel(JList list) {
            this.list = list;
        }

        @Override
        public boolean isSelectedIndex(int index) {
            ListModel listModel = this.list.getModel();
            Page page = (Page)listModel.getElementAt(index);
            return page != null && page.getTimeSpan().equals(PagingSelector.this.ganttChart.getTimeSpan());
        }

        @Override
        public boolean isSelectionEmpty() {
            return false;
        }
    }

    class PageVisualizer
    extends JPanel {
        private ITimeSpan totalSpan;
        private ITimeSpan span;
        private Color lineColor = new Color(148, 215, 148).darker();
        private Color fillColor1 = new Color(235, 250, 235);
        private Color fillColor2 = new Color(180, 235, 180);
        private Color selectionLineColor = new Color(215, 148, 148).darker();
        private Color selectionFillColor1 = new Color(250, 235, 235);
        private Color selectionFillColor2 = new Color(235, 180, 180);
        private boolean selected;

        public PageVisualizer() {
            this.setPreferredSize(new Dimension(100, 12));
            this.setOpaque(false);
        }

        public void setSpan(ITimeSpan span) {
            this.span = span;
        }

        public void setTotalSpan(ITimeSpan span) {
            this.totalSpan = span;
        }

        public void setSelected(boolean b2) {
            this.selected = b2;
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2;
            int w2 = this.getWidth();
            double mpp = (double)this.totalSpan.getDuration() / (double)(w2 - 4);
            int x1 = (int)((double)(this.span.getStartTime() - this.totalSpan.getStartTime()) / mpp);
            int x2 = (int)((double)(this.span.getEndTime() - this.totalSpan.getStartTime()) / mpp);
            int y2 = this.getHeight() / 2;
            g2d.setColor(Color.GRAY);
            g2d.drawLine(3, y2, w2 - 5, y2);
            g2d.drawLine(3, y2 + 1, w2 - 5, y2 + 1);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawRoundRect(0, y2 - 2, w2 - 2, 5, 6, 6);
            g2d.setColor(Color.BLUE);
            Color fc1 = this.fillColor1;
            Color fc2 = this.fillColor2;
            Color lc2 = this.lineColor;
            if (this.selected) {
                fc1 = this.selectionFillColor1;
                fc2 = this.selectionFillColor2;
                lc2 = this.selectionLineColor;
            }
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.7f));
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, fc1, 0.0f, this.getHeight(), fc2));
            g2d.fillRoundRect(x1, y2 - 4, x2 - x1, 8, 8, 8);
            g2d.setComposite(comp);
            g2d.setColor(lc2);
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawRoundRect(x1, y2 - 4, x2 - x1, 8, 8, 8);
            g2d.setStroke(stroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }
}

