/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.selector;

import com.dlsc.flexgantt.icons.BlankIcon;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.dateline.MarkerType;
import com.dlsc.flexgantt.policy.layer.IGridPolicy;
import com.dlsc.flexgantt.swing.IGridComponent;
import com.dlsc.flexgantt.swing.IGridComponentListener;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GridSelector
extends Selector {
    public GridSelector(JComponent comp, IGridComponent gridComponent) {
        super(gridComponent.getGridComponentName(), comp, Selector.Location.ABOVE);
        this.setContentComponent(new GranularityPanel(gridComponent));
    }

    private class GranularityPanel
    extends JPanel
    implements IGridComponentListener,
    ListSelectionListener {
        private JList list;
        private IGridComponent gridComponent;
        private int focusedRow = -1;

        protected GranularityPanel(IGridComponent comp) {
            this.gridComponent = comp;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.list = new JList();
            this.list.setCellRenderer(new GranularityListRenderer());
            this.list.setOpaque(false);
            this.list.setSelectionMode(0);
            this.list.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.list.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e2) {
                    int row = GranularityPanel.this.list.locationToIndex(e2.getPoint());
                    if (row != GranularityPanel.this.focusedRow) {
                        GranularityPanel.this.focusedRow = row;
                        GranularityPanel.this.repaint();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e2) {
                    GranularityPanel.this.focusedRow = -1;
                    GranularityPanel.this.repaint();
                }
            });
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(null);
            scroll.setOpaque(false);
            scroll.setViewportBorder(null);
            scroll.getViewport().setBorder(null);
            scroll.getViewport().setOpaque(false);
            scroll.setVerticalScrollBarPolicy(21);
            this.add("Center", scroll);
            this.updateList();
            this.gridComponent.addGridComponentListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e2) {
            if (!e2.getValueIsAdjusting()) {
                IGranularity granularity = (IGranularity)this.list.getSelectedValue();
                if (granularity instanceof NoGridGranularity) {
                    this.gridComponent.setGridGranularity(null);
                    this.gridComponent.setGridAutomatic(false);
                } else if (granularity instanceof AutomaticGridGranularity) {
                    this.gridComponent.setGridGranularity(null);
                    this.gridComponent.setGridAutomatic(true);
                } else {
                    this.gridComponent.setGridGranularity(granularity);
                    this.gridComponent.setGridAutomatic(false);
                }
                GridSelector.this.setVisible(false);
            }
        }

        private void updateList() {
            this.list.getSelectionModel().removeListSelectionListener(this);
            IGridPolicy gp = this.gridComponent.getGridPolicy();
            IGranularity[] granularities = gp.getGridGranularities();
            DefaultListModel<IGranularity> listModel = new DefaultListModel<IGranularity>();
            for (IGranularity g2 : granularities) {
                listModel.addElement(g2);
            }
            AutomaticGridGranularity autoGrid = new AutomaticGridGranularity();
            listModel.addElement(autoGrid);
            NoGridGranularity noGrid = new NoGridGranularity();
            listModel.addElement(noGrid);
            this.list.setModel(listModel);
            this.list.setVisibleRowCount(granularities.length + 2);
            IGranularity grid = this.gridComponent.getGridGranularity();
            if (grid != null) {
                this.list.setSelectedValue(grid, true);
            } else if (this.gridComponent.isGridAutomatic()) {
                this.list.setSelectedValue(autoGrid, true);
            } else {
                this.list.setSelectedValue(noGrid, true);
            }
            this.list.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void gridComponentChanged() {
            this.updateList();
        }

        private class GranularityListRenderer
        extends JLabel
        implements ListCellRenderer {
            private Icon selectionIcon;
            private Icon notSelectedIcon;
            private boolean focused;

            protected GranularityListRenderer() {
                this.setOpaque(false);
                this.selectionIcon = IconRegistry.getIcon(IconId.SELECTION_INDICATOR);
                this.notSelectedIcon = new BlankIcon(this.selectionIcon.getIconWidth(), this.selectionIcon.getIconHeight());
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                IGranularity granularity = (IGranularity)value;
                this.setText(granularity.getName());
                this.setForeground(Color.BLACK);
                if (isSelected) {
                    this.setIcon(this.selectionIcon);
                } else {
                    this.setIcon(this.notSelectedIcon);
                }
                this.focused = index == GranularityPanel.this.focusedRow;
                this.setOpaque(this.focused);
                if (this.focused) {
                    this.setForeground(Color.WHITE);
                    this.setBackground(Color.BLACK);
                }
                return this;
            }
        }

        class NoGridGranularity
        implements IGranularity<NoGridGranularity> {
            NoGridGranularity() {
            }

            @Override
            public String getName() {
                return Messages.getString("GridSelector.NO_GRID");
            }

            @Override
            public boolean isLarger(NoGridGranularity granularity) {
                return false;
            }

            @Override
            public boolean isSmaller(NoGridGranularity granularity) {
                return false;
            }

            @Override
            public boolean isDisplayingMarkerType(MarkerType type) {
                return false;
            }

            @Override
            public String getSingularName() {
                return this.getName();
            }

            @Override
            public long getStandardDuration() {
                return 1L;
            }
        }

        class AutomaticGridGranularity
        implements IGranularity<AutomaticGridGranularity> {
            AutomaticGridGranularity() {
            }

            @Override
            public String getName() {
                return Messages.getString("GridSelector.AUTOMATIC_GRID");
            }

            @Override
            public boolean isLarger(AutomaticGridGranularity granularity) {
                return false;
            }

            @Override
            public boolean isSmaller(AutomaticGridGranularity granularity) {
                return false;
            }

            @Override
            public boolean isDisplayingMarkerType(MarkerType type) {
                return false;
            }

            @Override
            public String getSingularName() {
                return this.getName();
            }

            @Override
            public long getStandardDuration() {
                return 1L;
            }
        }
    }
}

