/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.print;

import com.dlsc.flexgantt.swing.print.IPrintManager;
import com.dlsc.flexgantt.swing.print.PreviewDialog;
import com.dlsc.flexgantt.util.Messages;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class PreviewPaperPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(PreviewPaperPanel.class.getName());
    private ScaledPrintable printable;
    private PreviewDialog dialog;
    private int pageIndex;

    protected PreviewPaperPanel(PreviewDialog dialog, int page) {
        super(true);
        this.dialog = dialog;
        this.pageIndex = page;
        this.printable = new ScaledPrintable(dialog.getPrintGanttChart());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(new LineBorder(Color.BLACK));
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                Rectangle r2 = new Rectangle(e2.getX(), e2.getY(), 1, 1);
                ((JPanel)e2.getSource()).scrollRectToVisible(r2);
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        double scale = this.dialog.getScale();
        return this.getPreferredSize(scale);
    }

    public Dimension getPreferredSize(double scale) {
        IPrintManager printManager = this.dialog.getPrintManager();
        PageFormat pageFormat = printManager.getPageFormat();
        return new Dimension((int)(scale * pageFormat.getWidth()), (int)(scale * pageFormat.getHeight()));
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        double scale = this.dialog.getScale();
        IPrintManager printManager = this.dialog.getPrintManager();
        PageFormat pageFormat = printManager.getPageFormat();
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double ih = pageFormat.getImageableHeight() * scale;
        double iw = pageFormat.getImageableWidth() * scale;
        double ix = pageFormat.getImageableX() * scale;
        double iy = pageFormat.getImageableY() * scale;
        if (this.dialog.isShowMargins()) {
            Stroke oldStroke = g2d.getStroke();
            BasicStroke newStroke = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{3.0f, 2.0f}, 0.0f);
            g2d.setColor(Color.GRAY);
            g2d.setStroke(newStroke);
            g2d.drawRect((int)ix, (int)iy, (int)iw, (int)ih);
            g2d.setStroke(oldStroke);
        }
        Shape oldClip = g2d.getClip();
        g2d.clipRect((int)ix, (int)iy, (int)iw, (int)ih);
        try {
            int result = this.printable.print(g2d, pageFormat, this.pageIndex);
            if (result == 1) {
                g2.setColor(this.getForeground());
                g2.drawString(Messages.getString("PreviewPaperPanel.NO_SUCH_PAGE") + " (" + this.pageIndex + ")", 100, 100);
            }
        }
        catch (PrinterException e2) {
            g2.drawString(Messages.getString("PreviewPaperPanel.PRINTER_ERROR"), 100, 100);
            LOGGER.throwing(PreviewPaperPanel.class.getName(), "paintComponent", e2);
        }
        g2d.setClip(oldClip);
    }

    private class ScaledPrintable
    implements Printable {
        private Printable printableObject;

        protected ScaledPrintable(Printable printable) {
            this.printableObject = printable;
        }

        @Override
        public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
            double scale = PreviewPaperPanel.this.dialog.getScale();
            Graphics2D g2d = (Graphics2D)g2;
            AffineTransform oldTransform = g2d.getTransform();
            g2d.scale(scale, scale);
            int result = this.printableObject.print(g2, pageFormat, pageIndex);
            g2d.setTransform(oldTransform);
            return result;
        }
    }
}

