/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.IRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class DefaultRowRenderer
extends JPanel
implements IRowRenderer {
    protected IGanttChartModel model;
    protected Object node;
    private RowLayer rowLayer;
    private int row;
    private boolean selected;
    private ITimeSpan timeSpan;
    private boolean focus;
    private Color focusForeground = ColorUtil.makeTransparent(ColorUtil.getFocusForeground());
    private Color focusBackground = ColorUtil.makeTransparent(ColorUtil.getFocusBackground());
    private boolean focusVisible;
    private boolean paintingLines = true;
    private Color lineColor = Color.GRAY;
    private boolean showingSelection = true;
    private boolean debug;

    public DefaultRowRenderer() {
        this.setOpaque(false);
        this.setLayout(null);
    }

    @Override
    public Component getRowRendererComponent(RowLayer layer, Object node, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
        this.node = node;
        this.model = layer.getModel();
        this.rowLayer = layer;
        this.row = row;
        this.selected = selected;
        this.timeSpan = span;
        this.focus = hasFocus;
        this.setOpaque(false);
        if (this.focusVisible && this.focus) {
            this.setOpaque(true);
            this.setForeground(this.focusForeground);
            this.setBackground(this.focusBackground);
        }
        if (selected && this.isShowingSelection()) {
            this.setOpaque(true);
            this.setBackground(layer.getTreeTable().getSelectionBackground());
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.paintLines(g2);
    }

    protected void paintLines(Graphics g2) {
        LayerContainer lc2;
        IPolicyProvider pp;
        ILinePolicy lp;
        int lineCount;
        if (this.isPaintingLines() && (lineCount = (lp = (pp = (lc2 = this.rowLayer.getLayerContainer()).getPolicyProvider()).getPolicy(ILinePolicy.class)).getLineCount(this.node, this.model)) > 1) {
            int rowHeight = this.getHeight();
            Rectangle clip = g2.getClipBounds();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                if (!lp.isLineVisible(this.node, this.model, lineIndex)) continue;
                int y2 = lp.getLineLocation(this.node, this.model, lineIndex, rowHeight);
                g2.setColor(this.getLineColor(lineIndex));
                if (lineIndex > 0) {
                    g2.drawLine(clip.x, y2, clip.x + clip.width, y2);
                }
                if (!this.debug) continue;
                int x2 = 20 + lineIndex * 20;
                int height = lp.getLineHeight(this.node, this.model, lineIndex, rowHeight);
                g2.drawLine(x2, y2, x2, y2 + height);
                for (int i2 = 0; i2 < 4; ++i2) {
                    g2.drawLine(x2 - i2, y2 + i2, x2 + i2, y2 + i2);
                    g2.drawLine(x2 - i2, y2 + height - i2, x2 + i2, y2 + height - i2);
                }
                g2.drawString("Line " + lineIndex, x2 + 3, y2 + height / 2 + g2.getFontMetrics().getAscent());
            }
        }
    }

    public boolean isPaintingLines() {
        return this.paintingLines;
    }

    public void setPaintingLines(boolean paint) {
        this.paintingLines = paint;
    }

    protected Color getLineColor(int lineIndex) {
        return this.lineColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        if (lineColor == null) {
            throw new IllegalArgumentException("line color can not be NULL");
        }
        this.lineColor = lineColor;
    }

    protected IGanttChartModel getModel() {
        return this.model;
    }

    protected Object getNode() {
        return this.node;
    }

    protected RowLayer getRowLayer() {
        return this.rowLayer;
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    protected int getRow() {
        return this.row;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusBackground = color;
    }

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public void setFocusForeground(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.focusForeground = color;
    }

    public boolean isFocusVisible() {
        return this.focusVisible;
    }

    public void setFocusVisible(boolean visible) {
        this.focusVisible = visible;
    }

    public boolean isShowingSelection() {
        return this.showingSelection;
    }

    public void setShowingSelection(boolean show) {
        this.showingSelection = show;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

