/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.calendar.HolidayCalendarEntry;
import com.dlsc.flexgantt.model.calendar.ICalendarModel;
import com.dlsc.flexgantt.model.calendar.WeekendCalendarEntry;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.layer.system.DefaultCalendarEntryRenderer;
import com.dlsc.flexgantt.swing.layer.system.ICalendarEntryRenderer;
import com.dlsc.flexgantt.swing.layer.system.WeekendCalendarEntryRenderer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalendarLayer
extends AbstractSystemLayer {
    private static final Logger LOGGER = Logger.getLogger(CalendarLayer.class.getName());
    private Map<Class, ICalendarEntryRenderer> rendererMap = new HashMap<Class, ICalendarEntryRenderer>(10);
    private Map<Class, ICalendarEntryRenderer> rendererCache = new HashMap<Class, ICalendarEntryRenderer>(10);

    public CalendarLayer(LayerContainer lc2) {
        super("Calendar", lc2);
        this.setCalendarEntryRenderer(Object.class, new DefaultCalendarEntryRenderer());
        this.setCalendarEntryRenderer(WeekendCalendarEntry.class, new WeekendCalendarEntryRenderer());
        this.setCalendarEntryRenderer(HolidayCalendarEntry.class, new DefaultCalendarEntryRenderer(Color.ORANGE));
    }

    @Override
    protected void paintLayer(Graphics g2) {
        List<TreeTableNode> nodeList;
        Graphics2D g2d = (Graphics2D)g2;
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        Rectangle clip = g2.getClipBounds();
        Dateline dateline = this.getDateline();
        long s2 = dateline.getTimeAt(clip.x);
        long e2 = dateline.getTimeAt(clip.x + clip.width);
        int height = this.layerContainer.getHeight();
        TimeSpan clipSpan = new TimeSpan(s2, e2);
        ICalendarModel calendarModel = this.ganttChart.getCalendarModel();
        IDatelineModel datelineModel = dateline.getModel();
        Iterator iter = calendarModel.getCalendarEntries(datelineModel, clipSpan);
        if (iter != null) {
            while (iter.hasNext()) {
                Object calendarEntry = iter.next();
                ICalendarEntryRenderer renderer = this.getCalendarEntryRenderer(calendarEntry.getClass());
                if (renderer == null) continue;
                Component rendererComp = renderer.getCalendarEntryRendererComponent(this, calendarEntry);
                if (rendererComp != null) {
                    ITimeSpan span = calendarModel.getCalendarEntryTimeSpan(calendarEntry);
                    int x1 = dateline.getTimeLocation(span.getStartTime());
                    int x2 = dateline.getTimeLocation(span.getEndTime());
                    this.layerContainer.getRendererPane().paintComponent(g2d, rendererComp, this.layerContainer, x1, 0, x2 - x1, height, true);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "the renderer of type " + renderer.getClass().getName() + " did not return a component for rendering");
            }
        }
        if ((nodeList = this.layerContainer.getClipNodes()) != null) {
            for (TreeTableNode node : nodeList) {
                Object modelNode = node.getModelNode();
                iter = calendarModel.getCalendarEntries(datelineModel, modelNode, clipSpan);
                if (iter == null) continue;
                while (iter.hasNext()) {
                    Object calendarEntry = iter.next();
                    ICalendarEntryRenderer renderer = this.getCalendarEntryRenderer(calendarEntry.getClass());
                    Component rendererComp = renderer.getCalendarEntryRendererComponent(this, calendarEntry);
                    ITimeSpan span = calendarModel.getCalendarEntryTimeSpan(calendarEntry);
                    int x1 = dateline.getTimeLocation(span.getStartTime());
                    int x2 = dateline.getTimeLocation(span.getEndTime());
                    int y2 = node.getY();
                    int h2 = node.getHeight();
                    this.layerContainer.getRendererPane().paintComponent(g2d, rendererComp, this.layerContainer, x1, y2, x2 - x1, h2, true);
                }
            }
        }
        g2d.setComposite(comp);
        super.paintLayer(g2);
    }

    public void setCalendarEntryRenderer(Class objectType, ICalendarEntryRenderer renderer) {
        if (objectType == null) {
            throw new IllegalArgumentException("the object type can not be NULL");
        }
        this.rendererCache.clear();
        this.rendererMap.put(objectType, renderer);
    }

    public ICalendarEntryRenderer getCalendarEntryRenderer(Class cl) {
        if (cl == null) {
            return null;
        }
        ICalendarEntryRenderer renderer = this.rendererCache.get(cl);
        if (renderer != null) {
            return renderer;
        }
        renderer = this.rendererMap.get(cl);
        if (renderer != null) {
            this.rendererCache.put(cl, renderer);
            return renderer;
        }
        renderer = this.getCalendarEntryRenderer(cl.getSuperclass());
        this.rendererCache.put(cl, renderer);
        return renderer;
    }

    public Map<Class, ICalendarEntryRenderer> getCalendarEntryRendererMap() {
        return this.rendererMap;
    }

    public void setCalendarEntryRendererMap(Map<Class, ICalendarEntryRenderer> map) {
        if (map == null) {
            throw new IllegalArgumentException("map can not be null");
        }
        this.rendererMap = map;
    }
}

