/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.AbstractSystemLayer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.List;

public class BackgroundLayer
extends AbstractSystemLayer {
    private Image texture;
    private TexturePaint texturePaint;

    public BackgroundLayer(LayerContainer lc2) {
        super("Background", lc2);
    }

    @Override
    protected void paintLayer(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        Rectangle clip = g2.getClipBounds();
        if (this.texturePaint != null) {
            g2d.setPaint(this.texturePaint);
        } else {
            g2d.setColor(this.layerContainer.getBackground());
        }
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
        Color alternatingBackgroundColor = this.layerContainer.getAlternatingBackground();
        if (alternatingBackgroundColor != null) {
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            int row = 0;
            int y2 = 0;
            if (this.layerContainer.hasClipNodes()) {
                List<TreeTableNode> clipNodes = this.layerContainer.getClipNodes();
                int clipLine = 0;
                for (TreeTableNode node : clipNodes) {
                    if (y2 == 0) {
                        y2 = node.getY();
                    }
                    g2.clipRect(0, Math.max(clipLine, y2), this.getWidth(), this.getHeight());
                    row = node.getRow();
                    int rowHeight = node.getHeight();
                    if (row % 2 == 1) {
                        g2d.setColor(alternatingBackgroundColor);
                        g2d.fillRect(clip.x, y2, clip.width, rowHeight);
                    }
                    g2.setClip(clip);
                    y2 += node.getHeight();
                    TreeTable table = this.getTreeTable();
                    if (node != table.getAnimationNode()) continue;
                    clipLine = y2;
                    y2 -= (int)((double)node.getTotalChildrenHeight() * (1.0 - table.getAnimationPercentage()));
                }
                ++row;
            }
            g2.setClip(clip);
            TreeTable table = this.getTreeTable();
            int defaultRowHeight = table.getDefaultRowHeight();
            g2d.setColor(alternatingBackgroundColor);
            while (y2 < clip.y + clip.height) {
                if (row % 2 == 1) {
                    g2d.fillRect(clip.x, y2, clip.width, defaultRowHeight);
                }
                y2 += defaultRowHeight;
                ++row;
            }
            g2d.setComposite(comp);
        }
        super.paintLayer(g2);
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setTexture(Image texture) {
        this.texture = texture;
        if (texture != null) {
            BufferedImage buffer = new BufferedImage(texture.getWidth(this.layerContainer), texture.getHeight(this.layerContainer), 1);
            Graphics2D bg = buffer.createGraphics();
            bg.drawImage(texture, 0, 0, this.layerContainer);
            this.texturePaint = new TexturePaint(buffer, new Rectangle(0, 0, buffer.getWidth(), buffer.getHeight()));
        } else {
            this.texturePaint = null;
        }
        this.repaint();
    }
}

