/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.system.IPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import com.dlsc.flexgantt.swing.util.DropShadowBorder;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;

public abstract class AbstractPopupRenderer
extends JPanel
implements IPopupRenderer,
Border {
    private static final Logger LOGGER = Logger.getLogger(AbstractPopupRenderer.class.getName());
    private final JLabel titleLabel;
    private final JPanel header;
    private Color lineColor = new Color(255, 235, 155).darker();
    private Color textColor = Color.BLACK;
    private Color backgroundColor1 = new Color(255, 255, 235);
    private Color backgroundColor2 = new Color(255, 255, 155);
    private boolean pinned;
    private boolean renderingArrow = true;

    protected AbstractPopupRenderer() {
        this.setBorder(new CompoundBorder(new DropShadowBorder(), this));
        this.setOpaque(false);
        this.setLayout(new BorderLayout(5, 5));
        JComponent content = this.createContentArea();
        if (content == null) {
            throw new IllegalArgumentException("the content of the popup renderer can not be NULL");
        }
        content.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add("Center", content);
        this.header = new JPanel();
        this.header.setOpaque(false);
        this.header.setLayout(new BorderLayout());
        this.header.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 0, 5), new Border(){

            @Override
            public Insets getBorderInsets(Component c2) {
                return new Insets(0, 0, 1, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
                String txt = AbstractPopupRenderer.this.titleLabel.getText();
                if (txt != null && !txt.trim().equals("")) {
                    g2.setColor(AbstractPopupRenderer.this.lineColor);
                    g2.drawLine(x2, y2 + height - 1, x2 + width, y2 + height - 1);
                }
            }
        }));
        this.add("North", this.header);
        this.titleLabel = new JLabel("Titel");
        this.titleLabel.setForeground(Color.BLACK);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(this.getFont().deriveFont(1));
        this.titleLabel.setOpaque(false);
        this.header.add("Center", this.titleLabel);
    }

    @Override
    public void validate() {
        super.validate();
        this.header.doLayout();
        this.doLayout();
    }

    protected abstract JComponent createContentArea();

    @Override
    public JComponent getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, TimelineObjectPath path, IGanttChartModel model, boolean pinned) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("popup layer: " + pl);
            LOGGER.fine("path: " + path);
            LOGGER.fine("timeline model: " + model);
        }
        this.setEnabled(pl.getLayerContainer().isEnabled());
        this.pinned = pinned;
        String title = this.getPopupTitleText(titleValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("title: " + title);
        }
        this.titleLabel.setIcon(this.getTitleIcon(popupValue, path, model));
        this.titleLabel.setText(title);
        return this;
    }

    @Override
    public Component getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, TreePath path, IGanttChartModel model, boolean pinned) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("popup layer: " + pl);
            LOGGER.fine("path: " + path);
            LOGGER.fine("timeline model: " + model);
        }
        this.setEnabled(pl.getLayerContainer().isEnabled());
        this.pinned = pinned;
        String title = this.getPopupTitleText(titleValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("title: " + title);
        }
        this.titleLabel.setIcon(this.getTitleIcon(popupValue, path, model));
        this.titleLabel.setText(title);
        return this;
    }

    @Override
    public Component getPopupRendererComponent(PopupLayer pl, Object titleValue, Object popupValue, IRelationship relationship, IGanttChartModel model) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("popup layer: " + pl);
            LOGGER.fine("relationship: " + relationship);
            LOGGER.fine("timeline model: " + model);
        }
        this.setEnabled(pl.getLayerContainer().isEnabled());
        this.pinned = false;
        String title = this.getPopupTitleText(titleValue);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("title: " + title);
        }
        this.titleLabel.setIcon(this.getTitleIcon(popupValue, relationship, model));
        this.titleLabel.setText(title);
        return this;
    }

    protected Icon getTitleIcon(Object popupValue, TimelineObjectPath path, IGanttChartModel model) {
        return null;
    }

    protected Icon getTitleIcon(Object popupValue, TreePath path, IGanttChartModel model) {
        return null;
    }

    protected Icon getTitleIcon(Object popupValue, IRelationship relationship, IGanttChartModel model) {
        return null;
    }

    protected String getPopupText(Object popupValue) {
        if (popupValue != null) {
            return popupValue.toString();
        }
        return "";
    }

    protected String getPopupTitleText(Object titleValue) {
        if (titleValue != null) {
            return titleValue.toString();
        }
        return "";
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics2D g2d = (Graphics2D)g2.create();
        int[] xx = new int[]{0, 10, 16, 22, width - 1, width - 1, 0, 0};
        int[] yy = new int[]{6, 6, 0, 6, 6, height - 1, height - 1, 6};
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.backgroundColor1, 0.0f, height, this.backgroundColor2));
        if (this.pinned && this.renderingArrow) {
            g2d.fillPolygon(xx, yy, 8);
        } else {
            g2d.fillRect(x2, y2, width, height);
        }
        g2d.setColor(this.lineColor);
        if (this.pinned && this.renderingArrow) {
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawPolygon(xx, yy, 8);
        } else {
            g2d.drawRect(x2, y2, width - 1, height - 1);
        }
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        if (this.pinned) {
            return new Insets(8, 1, 1, 1);
        }
        return new Insets(1, 1, 1, 1);
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public Color getBackgroundColor1() {
        return this.backgroundColor1;
    }

    public void setBackgroundColor1(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.backgroundColor1 = color;
    }

    public Color getBackgroundColor2() {
        return this.backgroundColor2;
    }

    public void setBackgroundColor2(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.backgroundColor2 = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.lineColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color can not be NULL");
        }
        this.textColor = color;
    }

    public boolean isRenderingArrow() {
        return this.renderingArrow;
    }

    public void setRenderingArrow(boolean renderArrow) {
        this.renderingArrow = renderArrow;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

