/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.TimeSpanIterator;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModel;
import com.dlsc.flexgantt.swing.layer.ILayerContainerSelectionModelListener;
import com.dlsc.flexgantt.swing.layer.TimeSpanSelectionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DefaultLayerContainerSelectionModel
implements ILayerContainerSelectionModel {
    private static final Logger LOGGER = Logger.getLogger(DefaultLayerContainerSelectionModel.class.getName());
    private static final Iterator<ITimeSpan> EMPTY_ITERATOR = new Iterator<ITimeSpan>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ITimeSpan next() {
            throw new IllegalStateException("the empty iterator can not return any elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("nothing can be removed from the empty iterator");
        }
    };
    private EventListenerList listenerList = new EventListenerList();
    private Map<Object, List<ITimeSpan>> spanMap = new HashMap<Object, List<ITimeSpan>>();

    @Override
    public boolean isEmpty() {
        return this.spanMap.isEmpty();
    }

    @Override
    public boolean isEmpty(Object node) {
        return !this.spanMap.containsKey(node);
    }

    @Override
    public void clearSelectedTimeSpans() {
        LOGGER.fine("clearing all time span selections for all nodes");
        for (Object node : new HashSet<Object>(this.spanMap.keySet())) {
            this.clearSelectedTimeSpans(node);
        }
    }

    @Override
    public void clearSelectedTimeSpans(Object node) {
        LOGGER.fine("clearing time span selections for node = " + node);
        List<ITimeSpan> oldSelection = this.spanMap.get(node);
        this.spanMap.remove(node);
        this.fireTimeSpansRemoved(node, oldSelection);
    }

    @Override
    public void addSelectedTimeSpan(Object node, ITimeSpan span) {
        List<ITimeSpan> spanList;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adding a selected time span for node = " + node);
            LOGGER.fine("time span = " + span);
        }
        if ((spanList = this.spanMap.get(node)) == null) {
            spanList = new ArrayList<ITimeSpan>();
            this.spanMap.put(node, spanList);
        }
        spanList.add(span);
        Collections.sort(spanList);
        ArrayList<ITimeSpan> list = new ArrayList<ITimeSpan>();
        list.add(span);
        this.fireTimeSpansAdded(node, list);
    }

    @Override
    public void removeSelectedTimeSpan(Object node, ITimeSpan removedSpan) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("removing a selected time span from node = " + node);
            LOGGER.fine("time span = " + removedSpan);
        }
        List<ITimeSpan> spanList = this.spanMap.get(node);
        ArrayList<TimeSpan> addList = new ArrayList<TimeSpan>();
        ArrayList<ITimeSpan> removeList = new ArrayList<ITimeSpan>();
        if (spanList != null) {
            for (int i2 = 0; i2 < spanList.size(); ++i2) {
                ITimeSpan s2 = spanList.get(i2);
                if (!s2.intersects(removedSpan)) continue;
                if (removedSpan.getStartTime() > s2.getStartTime() && removedSpan.getEndTime() < s2.getEndTime()) {
                    TimeSpan newSpan = new TimeSpan(removedSpan.getEndTime(), s2.getEndTime());
                    addList.add(newSpan);
                    addList.add(new TimeSpan(s2.getStartTime(), removedSpan.getStartTime()));
                } else if (removedSpan.getStartTime() > s2.getStartTime()) {
                    addList.add(new TimeSpan(s2.getStartTime(), removedSpan.getStartTime()));
                } else {
                    addList.add(new TimeSpan(removedSpan.getEndTime(), s2.getEndTime()));
                }
                for (ITimeSpan iTimeSpan : addList) {
                    spanList.add(iTimeSpan);
                }
                removeList.add(s2);
            }
            for (ITimeSpan span : removeList) {
                spanList.remove(span);
            }
            Collections.sort(spanList);
            ArrayList<ITimeSpan> list = new ArrayList<ITimeSpan>();
            list.add(removedSpan);
            this.fireTimeSpansRemoved(node, list);
        }
    }

    @Override
    public Iterator<ITimeSpan> getSelectedTimeSpans(Object owner, ITimeSpan span) {
        List<ITimeSpan> list = this.spanMap.get(owner);
        if (list != null && list.size() > 0) {
            TimeSpanIterator<ITimeSpan> iterator = new TimeSpanIterator<ITimeSpan>(list, span);
            return iterator;
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean isSelected(Object node, ITimeSpan span) {
        List<ITimeSpan> list = this.spanMap.get(node);
        if (list != null) {
            for (ITimeSpan ts : list) {
                if (!ts.contains(span)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addLayerContainerSelectionModelListener(ILayerContainerSelectionModelListener l2) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ILayerContainerSelectionModelListener.class, l2);
    }

    @Override
    public void removeLayerContainerSelectionModelListener(ILayerContainerSelectionModelListener l2) {
        if (this.listenerList != null) {
            this.listenerList.remove(ILayerContainerSelectionModelListener.class, l2);
        }
    }

    protected void fireTimeSpansAdded(Object node, List<ITimeSpan> spans) {
        Object[] listeners = this.listenerList.getListenerList();
        TimeSpanSelectionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ILayerContainerSelectionModelListener.class) continue;
            if (e2 == null) {
                e2 = new TimeSpanSelectionEvent(this, node, spans);
            }
            ((ILayerContainerSelectionModelListener)listeners[i2 + 1]).timeSpansAdded(e2);
        }
    }

    protected void fireTimeSpansRemoved(Object node, List<ITimeSpan> spans) {
        Object[] listeners = this.listenerList.getListenerList();
        TimeSpanSelectionEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ILayerContainerSelectionModelListener.class) continue;
            if (e2 == null) {
                e2 = new TimeSpanSelectionEvent(this, node, spans);
            }
            ((ILayerContainerSelectionModelListener)listeners[i2 + 1]).timeSpansRemoved(e2);
        }
    }
}

