/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.action.gantt;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.action.gantt.AbstractGanttChartAction;
import com.dlsc.flexgantt.swing.treetable.CellFocusManager;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.tree.TreePath;

public class SplitGanttChartAction<T extends DualGanttChart>
extends AbstractGanttChartAction<T>
implements PropertyChangeListener {
    public SplitGanttChartAction(T gc2) {
        super(gc2, Messages.getString("SplitGanttChartAction.NAME"));
        this.setToolTipText(Messages.getString("SplitGanttChartAction.TOOLTIP"));
    }

    @Override
    public void setGanttChart(T gc2) {
        if (this.ganttChart != null) {
            ((DualGanttChart)this.ganttChart).removePropertyChangeListener(this);
        }
        super.setGanttChart(gc2);
        ((Container)gc2).addPropertyChangeListener(this);
        this.updateIcon();
    }

    private void updateIcon() {
        if (((DualGanttChart)this.ganttChart).isSecondaryVisible()) {
            this.putValue("SmallIcon", IconRegistry.getIcon(IconId.UNSPLIT_GANTT_CHART));
        } else {
            this.putValue("SmallIcon", IconRegistry.getIcon(IconId.SPLIT_GANTT_CHART));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        ((DualGanttChart)this.ganttChart).setSecondaryVisible(!((DualGanttChart)this.ganttChart).isSecondaryVisible());
        if (!((DualGanttChart)this.ganttChart).isSecondaryVisible()) {
            TreeTable pTable = ((DualGanttChart)this.ganttChart).getPrimaryTreeTable();
            TreeTable sTable = ((DualGanttChart)this.ganttChart).getSecondaryTreeTable();
            sTable.clearSelection();
            CellFocusManager pcfm = pTable.getCellFocusManager();
            CellFocusManager scfm = sTable.getCellFocusManager();
            if (scfm.hasFocus()) {
                pcfm.focusOnFirstVisibleCell();
                pcfm.setFocusedColumn(scfm.getFocusedColumn());
                scfm.looseFocus();
                TreePath path = pcfm.getFocusedPath();
                pTable.setSelectionPath(path);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.ganttChart) && evt.getPropertyName().equals("secondaryVisible")) {
            this.updateIcon();
        }
    }
}

