/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;

public class GanttChartProgressMonitor
implements IProgressMonitor {
    private static final Logger LOGGER = Logger.getLogger(GanttChartProgressMonitor.class.getName());
    private ProgressMonitor monitor;
    private boolean canceled;
    private int progress;
    private AbstractGanttChart gc;

    public GanttChartProgressMonitor(AbstractGanttChart gc2) {
        if (gc2 == null) {
            throw new IllegalArgumentException("gantt chart can not be NULL");
        }
        this.gc = gc2;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("name = " + name + " totalWork = " + totalWork);
        }
        if (this.monitor == null) {
            this.monitor = new ProgressMonitor(this.gc, name, "", 0, totalWork);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("changing max to " + (this.monitor.getMaximum() + totalWork));
            }
            this.monitor.setMaximum(this.monitor.getMaximum() + totalWork);
        }
        this.setTaskName(name);
    }

    @Override
    public void done() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("closing progress monitor");
        }
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    @Override
    public void setCanceled(boolean value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("canceled = " + value);
        }
        this.canceled = value;
    }

    @Override
    public boolean isCanceled() {
        if (this.monitor == null) {
            return this.canceled;
        }
        return this.canceled || this.monitor.isCanceled();
    }

    @Override
    public void setTaskName(String name) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("name = " + name);
        }
        this.monitor.setNote(name);
    }

    @Override
    public void subTask(String name) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("name = " + name);
        }
        this.monitor.setNote(name);
    }

    @Override
    public void worked(int work) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("work = " + work);
        }
        this.progress += work;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("new progress = " + this.progress + " minimum = " + this.monitor.getMinimum() + " maximum = " + this.monitor.getMaximum());
        }
        this.monitor.setProgress(this.progress);
    }

    @Override
    public void internalWorked(double work) {
    }
}

