/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IComponentFactory;
import com.dlsc.flexgantt.swing.NavigationControlPanel;
import com.dlsc.flexgantt.swing.UtilityControlPanel;
import com.dlsc.flexgantt.swing.layer.DefaultLayerFactory;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerRowHeader;
import com.dlsc.flexgantt.swing.layer.LayerContainerScrollPane;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableRowHeader;
import com.dlsc.flexgantt.swing.treetable.TreeTableScrollPane;
import com.dlsc.flexgantt.swing.util.CornerStone;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import com.dlsc.flexgantt.util.Messages;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DefaultComponentFactory
implements IComponentFactory {
    private static DefaultComponentFactory instance;

    protected DefaultComponentFactory() {
    }

    public static synchronized DefaultComponentFactory getInstance() {
        if (instance == null) {
            instance = new DefaultComponentFactory();
        }
        return instance;
    }

    @Override
    public Timeline createTimeline(AbstractGanttChart gc2) {
        return new Timeline(gc2);
    }

    @Override
    public Dateline createDateline(Timeline timeline) {
        return new Dateline(timeline);
    }

    @Override
    public Eventline createEventline(Timeline timeline, Dateline dateline) {
        return new Eventline(timeline, dateline);
    }

    @Override
    public TreeTable createTreeTable(AbstractGanttChart gc2, ITreeTableModel model) {
        TreeTable table = new TreeTable(gc2, model);
        return table;
    }

    @Override
    public TreeTableHeader createTreeTableHeader(AbstractGanttChart gc2) {
        return new TreeTableHeader(gc2);
    }

    @Override
    public TreeTableRowHeader createTreeTableRowHeader(TreeTable table) {
        return new TreeTableRowHeader(table);
    }

    @Override
    public JComponent createTreeTableCorner(TreeTable table, String corner) {
        CornerStone comp = null;
        if (corner.equals("UPPER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(true, false, true, true));
        } else if (corner.equals("LOWER_RIGHT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
        } else if (corner.equals("LOWER_LEFT_CORNER")) {
            comp = new CornerStone(table.getGanttChart());
            comp.setBorder(new CustomizableLineBorder(false, true, true, true));
        } else if (corner.equals("UPPER_LEFT_CORNER")) {
            final CornerStone control = new CornerStone(table.getGanttChart());
            control.getLabel().setToolTipText(Messages.getString("DefaultComponentFactory.COLUMN_CONTROLS"));
            final TreeTable fTable = table;
            control.getLabel().setShowingFocus(false);
            control.getLabel().addMouseListener(new MouseAdapter(){
                private Selector selector;

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (this.selector == null) {
                        ISelectorFactory sf = fTable.getGanttChart().getSelectorFactory();
                        this.selector = sf.createSelector(fTable.getGanttChart(), (JComponent)control, ISelectorFactory.SelectorID.COLUMNS);
                    }
                    this.selector.setVisible(!this.selector.isVisible());
                    this.selector.requestFocusInWindow();
                }
            });
            comp = control;
        }
        return comp;
    }

    @Override
    public LayerContainer createLayerContainer(AbstractGanttChart gc2, TreeTable table, IGanttChartModel model) {
        return new LayerContainer(gc2, model, table, DefaultLayerFactory.getInstance());
    }

    @Override
    public JComponent createLayerContainerCorner(LayerContainer lc2, String corner) {
        JPanel comp = null;
        if (corner.equals("UPPER_RIGHT_CORNER")) {
            comp = new NavigationControlPanel(lc2);
        } else if (!corner.equals("LOWER_RIGHT_CORNER")) {
            if (corner.equals("LOWER_LEFT_CORNER")) {
                comp = new UtilityControlPanel(lc2.getGanttChart());
            } else if (corner.equals("UPPER_LEFT_CORNER")) {
                comp = new CornerStone(lc2.getGanttChart());
            }
        }
        return comp;
    }

    @Override
    public LayerContainerRowHeader createLayerContainerRowHeader(LayerContainer lc2) {
        return new LayerContainerRowHeader(lc2);
    }

    @Override
    public LayerContainerScrollPane createLayerContainerScrollPane(LayerContainer lc2, LayerContainerRowHeader rowHeader, Timeline timeline, boolean primary) {
        return new LayerContainerScrollPane(lc2, rowHeader, timeline, primary);
    }

    @Override
    public TreeTableScrollPane createTreeTableScrollPane(TreeTable table, TreeTableRowHeader rowHeader, TreeTableHeader header, boolean primary) {
        return new TreeTableScrollPane(table, rowHeader, header, primary);
    }

    @Override
    public JSplitPane createSplitPane() {
        return new JSplitPane(1);
    }
}

