/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.scheduling;

import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.RelationshipType;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.AbstractConstraint;

public class TimeGranularityConstraint<T>
extends AbstractConstraint<T, TimeGranularity> {
    public TimeGranularityConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath) {
        super(sourcePath, targetPath);
        this.setBufferGranularity(TimeGranularity.DAY_SHORT);
    }

    public TimeGranularityConstraint(TimelineObjectPath<T> sourcePath, TimelineObjectPath<T> targetPath, RelationshipType type) {
        super(sourcePath, targetPath, type);
        this.setBufferGranularity(TimeGranularity.DAY_SHORT);
    }

    @Override
    protected double getDelta(long s2, long e2, TimeGranularity granularity) {
        long millis = s2 - e2;
        switch (granularity) {
            case MILLISECOND: {
                return millis;
            }
            case TEN_MILLISECONDS: {
                return (double)millis / 10.0;
            }
            case HUNDRED_MILLISECONDS: {
                return (double)millis / 100.0;
            }
            case SECOND: {
                return (double)millis / 1000.0;
            }
            case FIVE_SECONDS: {
                return (double)millis / 5000.0;
            }
            case TEN_SECONDS: {
                return (double)millis / 10000.0;
            }
            case FIFTEEN_SECONDS: {
                return (double)millis / 15000.0;
            }
            case THIRTY_SECONDS: {
                return (double)millis / 30000.0;
            }
            case MINUTE: {
                return (double)millis / 60000.0;
            }
            case FIVE_MINUTES: {
                return (double)millis / 300000.0;
            }
            case TEN_MINUTES: {
                return (double)millis / 600000.0;
            }
            case FIFTEEN_MINUTES: {
                return (double)millis / 900000.0;
            }
            case THIRTY_MINUTES: {
                return (double)millis / 1800000.0;
            }
            case HOUR: {
                return (double)millis / 3600000.0;
            }
            case THREE_HOURS: {
                return (double)millis / 1.08E7;
            }
            case SIX_HOURS: {
                return (double)millis / 2.16E7;
            }
            case DAY_SHORT: 
            case DAY_TINY: {
                return (double)millis / 8.64E7;
            }
            case WEEK: {
                return (double)millis / 6.048E8;
            }
            case MONTH_SHORT: 
            case MONTH_TINY: {
                return (double)millis / 2.592E9;
            }
            case QUARTER_YEAR: {
                return (double)millis / 7.776E9;
            }
            case HALF_YEAR: {
                return (double)millis / 1.5552E10;
            }
            case YEAR: {
                return (double)millis / 3.1104E10;
            }
            case DECADE: {
                return (double)millis / 3.1104E11;
            }
            case CENTURY: {
                return (double)millis / 3.1104E12;
            }
            case MILLENIUM: {
                return (double)millis / 3.1104E13;
            }
        }
        return 0.0;
    }
}

