/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinearSearchTimelineObjectIterator<T extends ITimelineObject>
implements Iterator<T> {
    private static final Logger LOGGER = Logger.getLogger(LinearSearchTimelineObjectIterator.class.getName());
    private List<T> objectList;
    private int index = -1;
    private ITimeSpan span;
    private boolean reverse;

    public LinearSearchTimelineObjectIterator(List<T> objectList, ITimeSpan span, boolean reverse) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.objectList = objectList;
        this.span = span;
        this.reverse = reverse;
        this.index = this.findFirstObject();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("object list size = " + objectList.size());
            LOGGER.fine("time span = " + span);
            LOGGER.fine("reverse = " + reverse);
            LOGGER.fine("index of first object = " + this.index);
        }
    }

    public LinearSearchTimelineObjectIterator(List<T> objectList, ITimeSpan span) {
        this(objectList, span, false);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("index = " + this.index);
        }
        return this.index >= 0 && this.index < this.objectList.size();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            if (this.reverse) {
                return (T)((ITimelineObject)this.objectList.get(this.index--));
            }
            return (T)((ITimelineObject)this.objectList.get(this.index++));
        }
        throw new UnsupportedOperationException("iterator has no more elements to return");
    }

    private int findFirstObject() {
        block4: {
            if (this.objectList == null || this.objectList.size() <= 0) break block4;
            if (this.reverse) {
                for (int i2 = this.objectList.size() - 1; i2 >= 0; --i2) {
                    ITimelineObject tlo = (ITimelineObject)this.objectList.get(i2);
                    ITimeSpan tloSpan = tlo.getTimeSpan();
                    if (!tloSpan.intersects(this.span)) continue;
                    return i2;
                }
            } else {
                for (int i3 = 0; i3 < this.objectList.size(); ++i3) {
                    ITimelineObject tlo = (ITimelineObject)this.objectList.get(i3);
                    ITimeSpan tloSpan = tlo.getTimeSpan();
                    if (!tloSpan.intersects(this.span)) continue;
                    return i3;
                }
            }
        }
        return -1;
    }
}

