/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.gantt.CapacityLine;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultResourceNode<T, S extends ITimelineObject>
extends DefaultGanttChartNode<T, S>
implements IResourceNode<S> {
    private List<CapacityLine> majorCapacityLines = new ArrayList<CapacityLine>();
    private List<CapacityLine> minorCapacityLines = new ArrayList<CapacityLine>();
    private double maximumCapacity;
    private double minimumCapacity;

    public DefaultResourceNode(T userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.init();
    }

    public DefaultResourceNode(T userObject) {
        super(userObject);
        this.init();
    }

    public DefaultResourceNode(boolean allowsChildren) {
        super(allowsChildren);
        this.init();
    }

    public DefaultResourceNode() {
        this.init();
    }

    private void init() {
        this.setMinimumCapacity(0.0);
        this.setMaximumCapacity(125.0);
        this.addMajorCapacityLine(new CapacityLine(100.0, "100%"));
        this.addMajorCapacityLine(new CapacityLine(50.0, "50%"));
        for (int i2 = 100; i2 >= 10; i2 -= 10) {
            this.addMinorCapacityLine(new CapacityLine(i2));
        }
    }

    @Override
    public List<CapacityLine> getCapacityLines(int rowHeight, boolean major) {
        if (major) {
            return this.majorCapacityLines;
        }
        return this.minorCapacityLines;
    }

    @Override
    public int getCapacityLocation(int rowHeight, double capacity) {
        double pixel = (double)rowHeight / (this.maximumCapacity - this.minimumCapacity);
        int loc = rowHeight - (int)((capacity - this.minimumCapacity) * pixel);
        return loc;
    }

    @Override
    public double getCapacityAt(int rowHeight, int y2) {
        if (rowHeight <= 0) {
            throw new IllegalArgumentException("row height must be larger than 0 but was " + rowHeight);
        }
        if (y2 < 0) {
            throw new IllegalArgumentException("y must be larger than or equal to 0 but was " + y2);
        }
        if (y2 > rowHeight) {
            throw new IllegalArgumentException("y must be smaller than or equal to the row height (y = " + y2 + " rowHeight = " + rowHeight + ")");
        }
        return this.minimumCapacity + (this.maximumCapacity - this.minimumCapacity) * ((double)y2 / (double)rowHeight);
    }

    public void addMajorCapacityLine(CapacityLine line) {
        if (line == null) {
            throw new IllegalArgumentException("capacity line can not be NULL");
        }
        if (this.majorCapacityLines == null) {
            this.majorCapacityLines = new ArrayList<CapacityLine>();
        }
        this.majorCapacityLines.add(line);
        Collections.sort(this.majorCapacityLines);
    }

    public void removeMajorCapacityLine(CapacityLine line) {
        if (line == null) {
            throw new IllegalArgumentException("capacity line can not be NULL");
        }
        if (this.majorCapacityLines != null) {
            this.majorCapacityLines.remove(line);
        }
    }

    public void addMinorCapacityLine(CapacityLine line) {
        if (line == null) {
            throw new IllegalArgumentException("capacity line can not be NULL");
        }
        if (this.minorCapacityLines == null) {
            this.minorCapacityLines = new ArrayList<CapacityLine>();
        }
        this.minorCapacityLines.add(line);
        Collections.sort(this.minorCapacityLines);
    }

    public void removeMinorCapacityLine(CapacityLine line) {
        if (line == null) {
            throw new IllegalArgumentException("capacity line can not be NULL");
        }
        if (this.minorCapacityLines != null) {
            this.minorCapacityLines.remove(line);
        }
    }

    public void clearMajorCapacityLines() {
        this.majorCapacityLines.clear();
    }

    public void clearMinorCapacityLines() {
        this.minorCapacityLines.clear();
    }

    @Override
    public double getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public void setMaximumCapacity(double capacity) {
        this.maximumCapacity = capacity;
    }

    @Override
    public double getMinimumCapacity() {
        return this.minimumCapacity;
    }

    public void setMinimumCapacity(double capacity) {
        this.minimumCapacity = capacity;
    }
}

