/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;
import com.dlsc.flexgantt.model.gantt.ISpreadsheetValuesList;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.LinearSearchTimelineObjectIterator;
import com.dlsc.flexgantt.model.gantt.SpreadsheetValuesList;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultGanttChartNode<T, S extends ITimelineObject>
extends DefaultMutableTreeTableNode<T>
implements IGanttChartNode<S> {
    private Map<ILayer, List<S>> listMap = new HashMap<ILayer, List<S>>();
    private int lineCount;
    private Map<ISpreadsheet, SpreadsheetValuesList> valuesListMap = new HashMap<ISpreadsheet, SpreadsheetValuesList>();
    private int[] lineLocationCache;

    public DefaultGanttChartNode(T userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public DefaultGanttChartNode(T userObject) {
        this(userObject, true);
    }

    public DefaultGanttChartNode(boolean allowsChildren) {
        this(null, allowsChildren);
    }

    public DefaultGanttChartNode() {
        this(null, true);
    }

    public void addTimelineObject(ILayer layer, S timelineObject) {
        int index;
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObject == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        List<S> list = this.listMap.get(layer);
        if (list == null) {
            list = new ArrayList<S>();
            this.listMap.put(layer, list);
        }
        if ((index = Collections.binarySearch(list, timelineObject)) < 0) {
            list.add(-index - 1, timelineObject);
        } else {
            list.add(index, timelineObject);
        }
    }

    public void setTimelineObjects(ILayer layer, Collection<S> timelineObjects) {
        this.clearTimelineObjects(layer);
        this.addTimelineObjects(layer, timelineObjects);
    }

    public void setTimelineObjects(ILayer layer, S[] timelineObjects) {
        this.clearTimelineObjects(layer);
        this.addTimelineObjects(layer, (ITimelineObject[])timelineObjects);
    }

    public void setTimelineObject(ILayer layer, S timelineObject) {
        this.clearTimelineObjects(layer);
        this.addTimelineObject(layer, timelineObject);
    }

    @Override
    public void addTimelineObjects(ILayer layer, Collection<S> timelineObjects) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObjects == null) {
            throw new IllegalArgumentException("timeline object collection can not be NULL");
        }
        List<S> list = this.listMap.get(layer);
        if (list == null) {
            list = new ArrayList<S>();
            this.listMap.put(layer, list);
        }
        list.addAll(timelineObjects);
        this.sortTimelineObjects(layer);
    }

    public void addTimelineObjects(ILayer layer, S[] timelineObjects) {
        this.addTimelineObjects(layer, (Collection<S>)Arrays.asList(timelineObjects));
    }

    public void removeTimelineObject(ILayer layer, S timelineObject) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObject == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        ArrayList<S> list = new ArrayList<S>();
        list.add(timelineObject);
        this.removeTimelineObjects(layer, (Collection<S>)list);
    }

    @Override
    public void removeTimelineObjects(ILayer layer, Collection<S> timelineObjects) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObjects == null) {
            throw new IllegalArgumentException("timeline object collection can not be NULL");
        }
        List<S> list = this.listMap.get(layer);
        if (list != null) {
            list.removeAll(timelineObjects);
        }
    }

    public void removeTimelineObjects(ILayer layer, S[] timelineObjects) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (timelineObjects == null) {
            throw new IllegalArgumentException("timeline object collection can not be NULL");
        }
        this.removeTimelineObjects(layer, (Collection<S>)Arrays.asList(timelineObjects));
    }

    @Override
    public List<S> getTimelineObjects() {
        ArrayList result = new ArrayList();
        for (ILayer layer : this.listMap.keySet()) {
            result.addAll(this.listMap.get(layer));
        }
        return result;
    }

    @Override
    public List<S> getTimelineObjects(ILayer layer) {
        List<S> list = this.listMap.get(layer);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public Iterator<S> getTimelineObjectsIterator(ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        List<Object> result = new ArrayList();
        for (ILayer layer : this.listMap.keySet()) {
            List<S> list = this.listMap.get(layer);
            for (ITimelineObject timelineObject : list) {
                ITimeSpan objSpan = timelineObject.getTimeSpan();
                if (!objSpan.intersects(span)) continue;
                result.add(timelineObject);
            }
        }
        if (result.size() > 0) {
            Collections.sort(result);
            return result.iterator();
        }
        result = Collections.emptyList();
        return result.iterator();
    }

    @Override
    public Iterator<S> getTimelineObjectsIterator(ILayer layer, ITimeSpan span) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        List<Object> list = this.listMap.get(layer);
        if (list != null && list.size() > 0) {
            return new LinearSearchTimelineObjectIterator<Object>(list, span);
        }
        list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public void clearTimelineObjects(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        List<S> list = this.listMap.get(layer);
        if (list != null) {
            this.listMap.remove(layer);
        }
    }

    @Override
    public boolean isSelectable(ITimeSpan span) {
        return true;
    }

    public void setLineCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("illegal line count " + count + " (must be larger than or equal to 0)");
        }
        this.lineCount = count;
        this.lineLocationCache = null;
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.lineLocationCache = null;
    }

    @Override
    public int getLineLocation(int lineIndex, int rowHeight) {
        int count = this.getLineCount();
        if (lineIndex >= count) {
            throw new IllegalArgumentException("illegal line index " + lineIndex + " (line count = " + count + ")");
        }
        if (this.lineLocationCache == null) {
            this.createLineLocationCache();
        }
        return this.lineLocationCache[lineIndex];
    }

    private void createLineLocationCache() {
        this.lineLocationCache = new int[this.lineCount];
        double rowHeight = this.getRowHeight();
        double h2 = rowHeight / (double)this.lineCount;
        for (int lineIndex = 0; lineIndex < this.lineCount; ++lineIndex) {
            this.lineLocationCache[lineIndex] = (int)((double)lineIndex * h2);
        }
    }

    @Override
    public int getLineHeight(int lineIndex, int rowHeight) {
        int count = this.getLineCount();
        if (lineIndex >= count) {
            throw new IllegalArgumentException("illegal line index " + lineIndex + " (line count = " + count + ")");
        }
        if (lineIndex >= 0) {
            if (lineIndex < count - 1) {
                return this.getLineLocation(lineIndex + 1, rowHeight) - this.getLineLocation(lineIndex, rowHeight);
            }
            return rowHeight - this.getLineLocation(count - 1, rowHeight) - 1;
        }
        return rowHeight;
    }

    public void sortTimelineObjects(ILayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        List<S> list = this.listMap.get(layer);
        if (list != null) {
            Collections.sort(list);
        }
    }

    public void validateTimelineObjectList(ILayer layer) {
        List<S> list = this.listMap.get(layer);
        if (list != null) {
            long time = -1L;
            for (ITimelineObject tlo : list) {
                long start = tlo.getTimeSpan().getStartTime();
                if (start >= time) {
                    time = start;
                    continue;
                }
                throw new IllegalStateException("ERROR: list of timeline objects of node " + this + " on layer " + layer + " is not sorted anymore");
            }
        }
    }

    @Override
    public int getDropActions(S timelineObject, long timePoint) {
        return 2;
    }

    @Override
    public boolean isTimelineObjectCreatableAt(ITimeSpan span, ILayer layer) {
        return true;
    }

    public void clearSpreadsheetValues(ISpreadsheet spreadsheet) {
        SpreadsheetValuesList list = this.valuesListMap.get(spreadsheet);
        if (list != null) {
            list.clearValues();
        }
    }

    @Override
    public Object getSpreadsheetValue(ISpreadsheet spreadsheet, ITimeSpan span) {
        ISpreadsheetValuesList list = this.valuesListMap.get(spreadsheet);
        if (list != null) {
            return list.getValue(span);
        }
        return null;
    }

    @Override
    public void setSpreadsheetValue(ISpreadsheet spreadsheet, Object value, ITimeSpan span) {
        SpreadsheetValuesList list = this.valuesListMap.get(spreadsheet);
        if (list == null) {
            list = new SpreadsheetValuesList();
            this.valuesListMap.put(spreadsheet, list);
        }
        list.setValue(value, span);
    }
}

