/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.IMutableTreeTableNode;
import com.dlsc.flexgantt.util.Messages;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultNodeDragAndDropCommand
extends AbstractCommand {
    private static final Logger LOGGER = Logger.getLogger(DefaultNodeDragAndDropCommand.class.getName());
    private IMutableTreeTableNode draggedNode;
    private IMutableTreeTableNode oldParent;
    private IMutableTreeTableNode newParent;
    private DefaultTreeTableModel oldModel;
    private DefaultTreeTableModel newModel;
    private int oldChildIndex;
    private int newChildIndex;
    private int dropAction;

    public DefaultNodeDragAndDropCommand(IMutableTreeTableNode draggedNode, IMutableTreeTableNode oldParentNode, DefaultTreeTableModel oldModel, int oldChildIndex, IMutableTreeTableNode newParentNode, DefaultTreeTableModel newModel, int newChildIndex, int dropAction) {
        super(Messages.getString("DefaultNodeDragAndDropCommand.NAME"));
        if (draggedNode == null) {
            throw new IllegalArgumentException("dragged node can not be NULL");
        }
        if (oldParentNode == null) {
            throw new IllegalArgumentException("old parent node can not be NULL");
        }
        if (oldModel == null) {
            throw new IllegalArgumentException("old model can not be NULL");
        }
        if (newParentNode == null) {
            throw new IllegalArgumentException("new parent node can not be NULL");
        }
        if (newModel == null) {
            throw new IllegalArgumentException("new model can not be NULL");
        }
        if (dropAction == 1) {
            throw new IllegalArgumentException("the default drop command for nodes does not support the COPY action (DnDConstants.COPY)");
        }
        this.draggedNode = draggedNode;
        this.oldParent = oldParentNode;
        this.oldModel = oldModel;
        this.oldChildIndex = oldChildIndex;
        this.newParent = newParentNode;
        this.newModel = newModel;
        this.newChildIndex = newChildIndex;
        this.dropAction = dropAction;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("object = " + this.oldModel.getKey(this.draggedNode));
            LOGGER.fine("source = " + this.oldModel.getKey(this.oldParent));
            LOGGER.fine("souce index = " + this.oldChildIndex);
            LOGGER.fine("target = " + this.newModel.getKey(this.newParent));
            LOGGER.fine("target index = " + this.newChildIndex);
        }
        TreePath oldPath = new TreePath(this.oldModel.getPathToRoot(this.draggedNode));
        this.oldParent.remove(this.draggedNode);
        this.newParent.insert(this.draggedNode, this.newChildIndex);
        TreePath newPath = new TreePath(this.newModel.getPathToRoot(this.draggedNode));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("old path = " + oldPath);
            LOGGER.fine("new path = " + newPath);
        }
        if (this.draggedNode instanceof IGanttChartNode) {
            this.fixRelationships(this.draggedNode, oldPath, newPath);
        }
        this.oldModel.nodesWereRemoved(this.oldParent, new int[]{this.oldChildIndex}, new Object[]{this.draggedNode});
        this.newModel.nodesWereInserted(this.newParent, new int[]{this.newChildIndex});
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        TreePath oldPath = new TreePath(this.oldModel.getPathToRoot(this.draggedNode));
        this.newParent.remove(this.draggedNode);
        this.oldParent.insert(this.draggedNode, this.oldChildIndex);
        TreePath newPath = new TreePath(this.newModel.getPathToRoot(this.draggedNode));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("old path = " + oldPath);
            LOGGER.fine("new path = " + newPath);
        }
        if (this.draggedNode instanceof IGanttChartNode) {
            this.fixRelationships(this.draggedNode, oldPath, newPath);
        }
        this.newModel.nodesWereRemoved(this.newParent, new int[]{this.newChildIndex}, new Object[]{this.draggedNode});
        this.oldModel.nodesWereInserted(this.oldParent, new int[]{this.oldChildIndex});
    }

    private void fixRelationships(TreeNode node, TreePath oldPath, TreePath newPath) {
        DefaultGanttChartModel oldGanttModel = (DefaultGanttChartModel)this.oldModel;
        DefaultGanttChartModel newGanttModel = (DefaultGanttChartModel)this.newModel;
        LinkedList<IRelationship> oldRelationships = new LinkedList<IRelationship>();
        LinkedList newRelationships = new LinkedList();
        Iterator iter = oldGanttModel.getRelationships();
        while (iter.hasNext()) {
            IRelationship rel = iter.next();
            TimelineObjectPath sourcePath = rel.getSourcePath();
            TimelineObjectPath targetPath = rel.getTargetPath();
            TimelineObjectPath newSourcePath = new TimelineObjectPath(newPath, sourcePath.getTimelineObject(), sourcePath.getLayer());
            TimelineObjectPath newTargetPath = new TimelineObjectPath(newPath, targetPath.getTimelineObject(), targetPath.getLayer());
            boolean include = false;
            if (sourcePath.getTreePath().equals(oldPath) && targetPath.getTreePath().equals(oldPath)) {
                rel.setSourcePath(newSourcePath);
                rel.setTargetPath(newTargetPath);
                include = true;
            } else if (sourcePath.getTreePath().equals(oldPath)) {
                rel.setSourcePath(newSourcePath);
                include = true;
            } else if (targetPath.getTreePath().equals(oldPath)) {
                rel.setTargetPath(newTargetPath);
                include = true;
            }
            if (!include) continue;
            newRelationships.add(rel);
            oldRelationships.add(rel);
        }
        oldGanttModel.removeRelationships(oldRelationships);
        newGanttModel.addRelationships(newRelationships);
        if (!node.isLeaf()) {
            int count = node.getChildCount();
            for (int i2 = 0; i2 < count; ++i2) {
                TreeNode child = node.getChildAt(i2);
                this.fixRelationships(child, oldPath.pathByAddingChild(child), newPath.pathByAddingChild(child));
            }
        }
    }

    public IMutableTreeTableNode getDraggedNode() {
        return this.draggedNode;
    }

    public IMutableTreeTableNode getNewParent() {
        return this.newParent;
    }

    public IMutableTreeTableNode getOldParent() {
        return this.oldParent;
    }

    public int getNewChildIndex() {
        return this.newChildIndex;
    }

    public int getOldChildIndex() {
        return this.oldChildIndex;
    }

    public DefaultTreeTableModel getOldModel() {
        return this.oldModel;
    }

    public DefaultTreeTableModel getNewModel() {
        return this.newModel;
    }

    public int getDropAction() {
        return this.dropAction;
    }
}

