/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangeKeyCommand
extends AbstractCommand {
    private ITreeTableNode node;
    private DefaultTreeTableModel model;
    private Object newKey;
    private Object oldKey;

    public DefaultChangeKeyCommand(DefaultMutableTreeTableNode node, DefaultTreeTableModel model, Object key) {
        super(Messages.getString("DefaultChangeKeyCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.node = node;
        this.model = model;
        this.newKey = key;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        monitor.beginTask("Changing key to: " + this.newKey, 1);
        this.oldKey = this.model.getKey(this.node);
        this.model.setKey(this.node, this.newKey);
        monitor.done();
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        monitor.beginTask("Restoring key back to: " + this.oldKey, 1);
        this.model.setKey(this.node, this.oldKey);
        monitor.done();
    }

    public DefaultTreeTableModel getModel() {
        return this.model;
    }

    public Object getNewKey() {
        return this.newKey;
    }

    public Object getOldKey() {
        return this.oldKey;
    }

    public ITreeTableNode getNode() {
        return this.node;
    }
}

