/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.util.Messages;

public class DefaultRemoveLayerCommand
extends AbstractCommand {
    private ILayer layer;
    private DefaultGanttChartModel model;

    public DefaultRemoveLayerCommand(ILayer layer, DefaultGanttChartModel model) {
        super(Messages.getString("DefaultRemoveLayerCommand.NAME"));
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.layer = layer;
        this.model = model;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeLayer(this.layer);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.addLayer(this.layer);
    }

    public ILayer getLayer() {
        return this.layer;
    }

    public IGanttChartModel getModel() {
        return this.model;
    }
}

