/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.session;

import java.awt.Component;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XProperties {
    public void registerPersistenceDelegates() {
        XMLEncoder encoder = new XMLEncoder(System.out);
        encoder.setPersistenceDelegate(ColumnState.class, new DefaultPersistenceDelegate(new String[]{"width", "preferredWidth", "modelIndex", "visible", "viewIndex"}));
        encoder.setPersistenceDelegate(XTableState.class, new DefaultPersistenceDelegate(new String[]{"columnStates", "horizontalScrollEnabled"}));
    }

    public static class VisibleColumnIndexComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((ColumnState)o1).getViewIndex() - ((ColumnState)o2).getViewIndex();
        }
    }

    public static class ColumnState {
        private int width;
        private int preferredWidth;
        private int modelIndex;
        private boolean visible;
        private int viewIndex;

        public ColumnState(int width, int preferredWidth, int modelColumn, boolean visible, int viewIndex) {
            this.width = width;
            this.preferredWidth = preferredWidth;
            this.modelIndex = modelColumn;
            this.visible = visible;
            this.viewIndex = viewIndex;
        }

        public ColumnState(TableColumnExt columnExt, int viewIndex) {
            this(columnExt.getWidth(), columnExt.getPreferredWidth(), columnExt.getModelIndex(), columnExt.isVisible(), viewIndex);
        }

        public void configureColumn(TableColumnExt columnExt) {
            if (this.modelIndex != columnExt.getModelIndex()) {
                return;
            }
            columnExt.setPreferredWidth(this.preferredWidth);
            columnExt.setWidth(this.width);
            columnExt.setVisible(this.visible);
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }
    }

    public static class XTableState {
        ColumnState[] columnStates = new ColumnState[0];
        boolean horizontalScrollEnabled;

        public XTableState(ColumnState[] columnStates, boolean horizontalScrollEnabled) {
            this.columnStates = this.copyColumnStates(columnStates);
            this.setHorizontalScrollEnabled(horizontalScrollEnabled);
        }

        public XTableState(ColumnState[] columnStates) {
            this.columnStates = this.copyColumnStates(columnStates);
        }

        public ColumnState[] getColumnStates() {
            return this.copyColumnStates(this.columnStates);
        }

        public boolean getHorizontalScrollEnabled() {
            return this.horizontalScrollEnabled;
        }

        public void setHorizontalScrollEnabled(boolean horizontalScrollEnabled) {
            this.horizontalScrollEnabled = horizontalScrollEnabled;
        }

        private ColumnState[] copyColumnStates(ColumnState[] states) {
            if (states == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            ColumnState[] copy = new ColumnState[states.length];
            System.arraycopy(states, 0, copy, 0, states.length);
            return copy;
        }
    }

    public static class XTableProperty
    implements PropertySupport {
        @Override
        public Object getSessionState(Component c2) {
            this.checkComponent(c2);
            JXTable table = (JXTable)c2;
            ArrayList<ColumnState> columnStates = new ArrayList<ColumnState>();
            List<TableColumn> columns = table.getColumns(true);
            List<TableColumn> visibleColumns = table.getColumns();
            for (TableColumn column : columns) {
                columnStates.add(new ColumnState((TableColumnExt)column, visibleColumns.indexOf(column)));
            }
            XTableState tableState = new XTableState(columnStates.toArray(new ColumnState[columnStates.size()]));
            tableState.setHorizontalScrollEnabled(table.isHorizontalScrollEnabled());
            return tableState;
        }

        @Override
        public void setSessionState(Component c2, Object state) {
            this.checkComponent(c2);
            JXTable table = (JXTable)c2;
            XTableState tableState = (XTableState)state;
            ColumnState[] columnState = tableState.getColumnStates();
            List<TableColumn> columns = table.getColumns(true);
            if (this.canRestore(columnState, columns)) {
                for (int i2 = 0; i2 < columnState.length; ++i2) {
                    columnState[i2].configureColumn((TableColumnExt)columns.get(i2));
                }
                this.restoreVisibleSequence(columnState, table.getColumnModel());
            }
            table.setHorizontalScrollEnabled(tableState.getHorizontalScrollEnabled());
        }

        private void restoreVisibleSequence(ColumnState[] columnStates, TableColumnModel model) {
            List<ColumnState> visibleStates = this.getSortedVisibleColumnStates(columnStates);
            for (int i2 = 0; i2 < visibleStates.size(); ++i2) {
                TableColumn column = model.getColumn(i2);
                int modelIndex = visibleStates.get(i2).getModelIndex();
                if (modelIndex == column.getModelIndex()) continue;
                int currentIndex = -1;
                for (int j2 = i2 + 1; j2 < model.getColumnCount(); ++j2) {
                    TableColumn current = model.getColumn(j2);
                    if (current.getModelIndex() != modelIndex) continue;
                    currentIndex = j2;
                    break;
                }
                model.moveColumn(currentIndex, i2);
            }
        }

        private List<ColumnState> getSortedVisibleColumnStates(ColumnState[] columnStates) {
            ArrayList<ColumnState> visibleStates = new ArrayList<ColumnState>();
            for (ColumnState columnState : columnStates) {
                if (!columnState.getVisible()) continue;
                visibleStates.add(columnState);
            }
            Collections.sort(visibleStates, new VisibleColumnIndexComparator());
            return visibleStates;
        }

        private boolean canRestore(ColumnState[] columnState, List<TableColumn> columns) {
            if (columnState == null || columnState.length != columns.size()) {
                return false;
            }
            for (int i2 = 0; i2 < columnState.length; ++i2) {
                if (columnState[i2].getModelIndex() == columns.get(i2).getModelIndex()) continue;
                return false;
            }
            return true;
        }

        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JXTable)) {
                throw new IllegalArgumentException("invalid component - expected JXTable");
            }
        }
    }
}

