/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.renderer;

import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightGanttChartNode;
import com.dlsc.emirates.model.FlightGroupGanttChartNode;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EmiratesTreeTableCellRenderer
extends DefaultTreeTableCellRenderer {
    private static final Icon planeIcon = new ImageIcon(EmiratesTreeTableCellRenderer.class.getResource("airplane.png"));
    private static final Icon flightIcon = new ImageIcon(EmiratesTreeTableCellRenderer.class.getResource("cube_green.png"));
    private static final Icon flightGroupIcon = new ImageIcon(EmiratesTreeTableCellRenderer.class.getResource("cubes.png"));

    @Override
    public Component getTreeTableCellRendererComponent(TreeTable tree, Object node, Object value, int depth, boolean selected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
        Component comp = super.getTreeTableCellRendererComponent(tree, node, value, depth, selected, expanded, leaf, row, column, hasFocus);
        if (!leaf) {
            Font font = tree.getFont();
            comp.setFont(font.deriveFont(1));
        }
        return comp;
    }

    @Override
    protected Icon getIcon(Object node, Object value, int column, boolean leaf, boolean expanded) {
        if ((column == -1 || column == Integer.MIN_VALUE) && value != null) {
            if (leaf) {
                if (node instanceof AircraftGanttChartNode) {
                    return planeIcon;
                }
                if (node instanceof FlightGanttChartNode) {
                    return flightIcon;
                }
                if (node instanceof FlightGroupGanttChartNode) {
                    return flightGroupIcon;
                }
            }
            return super.getIcon(node, value, column, leaf, expanded);
        }
        return null;
    }
}

