/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.renderer;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.swing.AbstractEmiratesGanttChart;
import com.dlsc.emirates.swing.hud.SettingsHUD;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;

public class EmiratesRowRenderer
extends DefaultRowRenderer {
    private int ascent;
    private AbstractEmiratesGanttChart ganttChart;
    private Color searchColor = new Color(255, 0, 0, 200);

    public EmiratesRowRenderer() {
        this.setPaintingLines(true);
        this.setLineColor(new Color(240, 240, 240));
        this.setFont(new Font("courier", 0, 10));
    }

    @Override
    public Component getRowRendererComponent(RowLayer layer, Object node, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
        super.getRowRendererComponent(layer, node, selected, row, span, hasFocus);
        this.ganttChart = (AbstractEmiratesGanttChart)layer.getGanttChart();
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.ganttChart.getSearchTerm() != null) {
            this.paintSearchResults(g2);
        }
        this.paintAirports(g2);
    }

    private void paintSearchResults(Graphics g2) {
        AircraftGanttChartNode node = (AircraftGanttChartNode)this.getNode();
        Graphics2D g2d = (Graphics2D)g2;
        RowLayer rowLayer = this.getRowLayer();
        LayerContainer lc2 = rowLayer.getLayerContainer();
        ITimeSpan span = this.getTimeSpan();
        for (ILayer layer : lc2.getLayers()) {
            TimelineObjectLayer tloLayer = lc2.getTimelineObjectLayer(layer);
            if (!tloLayer.isVisible()) continue;
            Composite comp = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, tloLayer.getAlpha()));
            Iterator<FlightTimelineObject> iter = node.getTimelineObjectsIterator(layer, span);
            while (iter.hasNext()) {
                FlightTimelineObject flightTlo = iter.next();
                ObjectBounds bounds = lc2.getObjectBounds(new TimelineObjectPath<FlightTimelineObject>(node.getPath(), flightTlo, layer));
                if (!((ROW)flightTlo.getUserObject()).getFLIGHTNO().equals(this.ganttChart.getSearchTerm())) continue;
                g2d.setColor(this.searchColor);
                bounds.grow(8, 8);
                g2d.fillRect(bounds.x, bounds.y - this.getLocation().y, bounds.width, bounds.height);
            }
            g2d.setComposite(comp);
        }
    }

    private void paintAirports(Graphics g2) {
        RowLayer rowLayer;
        LayerContainer lc2;
        Dateline dateline;
        TimeGranularity timeGranularity;
        if (this.getHeight() > 34 && SettingsHUD.showAirports.isSelected() && (timeGranularity = (TimeGranularity)(dateline = (lc2 = (rowLayer = this.getRowLayer()).getLayerContainer()).getDateline()).getModel().getGranularity()).isSmaller(TimeGranularity.WEEK)) {
            Graphics2D g2d = (Graphics2D)g2;
            FontMetrics fm = g2d.getFontMetrics();
            this.ascent = fm.getAscent();
            ITimeSpan span = this.getTimeSpan();
            if (this.isSelected()) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(Color.BLACK);
            }
            AircraftGanttChartNode node = (AircraftGanttChartNode)this.getNode();
            for (ILayer layer : lc2.getLayers()) {
                TimelineObjectLayer tloLayer = lc2.getTimelineObjectLayer(layer);
                if (!tloLayer.isVisible()) continue;
                Composite comp = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, tloLayer.getAlpha()));
                Iterator<FlightTimelineObject> iter = node.getTimelineObjectsIterator(layer, span);
                while (iter.hasNext()) {
                    FlightTimelineObject flightTlo = iter.next();
                    ObjectBounds bounds = lc2.getObjectBounds(new TimelineObjectPath<FlightTimelineObject>(node.getPath(), flightTlo, layer));
                    if (bounds == null || bounds.width <= 20) continue;
                    bounds.translate(0, -this.getY());
                    this.paintAirportLabels(g2d, bounds, flightTlo);
                }
                g2d.setComposite(comp);
            }
        }
    }

    private void paintAirportLabels(Graphics2D g2d, ObjectBounds bounds, FlightTimelineObject flightTimelineObject) {
        ROW row = (ROW)flightTimelineObject.getUserObject();
        g2d.drawString(row.getDEPARTURESTATION(), bounds.x + 2, bounds.y - 2);
        FontMetrics fm = g2d.getFontMetrics();
        String arrivalStation = row.getARRIVALSTATION();
        g2d.drawString(arrivalStation, bounds.x + bounds.width - fm.stringWidth(arrivalStation) - 2, bounds.y + bounds.height + this.ascent - 2);
    }
}

