/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.components;

import com.dlsc.emirates.EmiratesPOC;
import com.dlsc.emirates.swing.components.AnimatedSplitPaneEvent;
import com.dlsc.emirates.swing.components.AnimatedSplitPaneState;
import com.dlsc.emirates.swing.components.IAnimatedSplitPaneListener;
import de.centigrade.bizlaf.BizLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class AnimatedSplitPane
extends JSplitPane
implements TimingTarget,
PropertyChangeListener {
    private AnimatedSplitPaneState state = AnimatedSplitPaneState.OPEN;
    private int duration = 150;
    private int dividerSize = -1;
    private boolean hideRightOrBottomComponent = true;

    public AnimatedSplitPane(boolean hideRightOrBottomComponent) {
        super(0, new JLabel("Top"), new JTree());
        this.hideRightOrBottomComponent = hideRightOrBottomComponent;
        this.dividerSize = this.getDividerSize();
        if (hideRightOrBottomComponent) {
            this.setResizeWeight(1.0);
        } else {
            this.setResizeWeight(0.0);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setContinuousLayout(true);
        this.addPropertyChangeListener(this);
    }

    public AnimatedSplitPane() {
        this(true);
    }

    @Override
    public void setBottomComponent(Component comp) {
        super.setBottomComponent(comp);
        if (comp != null && this.hideRightOrBottomComponent && !this.isOpen()) {
            comp.setVisible(false);
        }
    }

    @Override
    public void setTopComponent(Component comp) {
        super.setTopComponent(comp);
        if (comp != null && !this.hideRightOrBottomComponent && !this.isOpen()) {
            comp.setVisible(false);
        }
    }

    @Override
    public void setLeftComponent(Component comp) {
        super.setLeftComponent(comp);
        if (comp != null && !this.hideRightOrBottomComponent && !this.isOpen()) {
            comp.setVisible(false);
        }
    }

    @Override
    public void setRightComponent(Component comp) {
        super.setRightComponent(comp);
        if (comp != null && this.hideRightOrBottomComponent && !this.isOpen()) {
            comp.setVisible(false);
        }
    }

    public boolean isHideingRightOrBottomComponent() {
        return this.hideRightOrBottomComponent;
    }

    public void makeSingleLineDivider() {
        BasicSplitPaneUI ui = new BasicSplitPaneUI();
        this.setUI(ui);
        ui.getDivider().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(0xA5A5A5)));
        this.dividerSize = 1;
        this.setDividerSize(1);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (EmiratesPOC.isAqua()) {
            this.setUI(new BasicSplitPaneUI(){

                @Override
                protected void installDefaults() {
                    super.installDefaults();
                    BasicSplitPaneDivider divider = this.getDivider();
                    if (this.getOrientation() == 0 && divider.getBorder() == null) {
                        Border border = null;
                        border = UIManager.getBorder("SplitPaneDivider.horizontalGradientVariant");
                        divider.setBorder(border);
                    }
                }
            });
            this.setBorder(null);
        }
    }

    public void addAnimatedSplitPaneListener(IAnimatedSplitPaneListener l2) {
        this.listenerList.add(IAnimatedSplitPaneListener.class, l2);
    }

    public void removeAnimatedSplitPaneListener(IAnimatedSplitPaneListener l2) {
        this.listenerList.remove(IAnimatedSplitPaneListener.class, l2);
    }

    protected void fireAnimatedSplitPaneEvent(AnimatedSplitPaneEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IAnimatedSplitPaneListener.class) continue;
            ((IAnimatedSplitPaneListener)listeners[i2 + 1]).splitChanged(evt);
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isOpen() {
        return this.state == null || this.state == AnimatedSplitPaneState.OPEN;
    }

    public void toggle() {
        if (this.isOpen()) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() throws IllegalStateException {
        switch (this.state) {
            case CLOSED: {
                this.doOpen();
                break;
            }
        }
    }

    public void openWithoutAnimation() throws IllegalStateException {
        switch (this.state) {
            case CLOSED: {
                this.beginOpening();
                this.endOpening();
                break;
            }
        }
    }

    private void doOpen() {
        this.state = AnimatedSplitPaneState.OPENING;
        Animator anim = new Animator(this.duration, this);
        anim.setStartDirection(Animator.Direction.FORWARD);
        anim.start();
    }

    public void close() {
        switch (this.state) {
            case OPEN: {
                this.doClose();
                break;
            }
        }
    }

    public void closeWithoutAnimation() {
        switch (this.state) {
            case OPEN: {
                this.endClosing();
                break;
            }
        }
    }

    private void doClose() {
        this.state = AnimatedSplitPaneState.CLOSING;
        Animator anim = new Animator(this.duration, this);
        anim.setStartFraction(1.0f);
        anim.setStartDirection(Animator.Direction.BACKWARD);
        anim.start();
    }

    @Override
    public synchronized void begin() {
        switch (this.state) {
            case OPENING: {
                this.beginOpening();
            }
        }
    }

    private void beginOpening() {
        this.setDividerSize(this.dividerSize);
        if (this.hideRightOrBottomComponent) {
            if (this.getBottomComponent() != null) {
                this.getBottomComponent().setVisible(true);
            }
        } else if (this.getTopComponent() != null) {
            this.getTopComponent().setVisible(true);
        }
    }

    @Override
    public synchronized void end() {
        switch (this.state) {
            case OPENING: {
                this.endOpening();
                break;
            }
            case CLOSING: {
                this.endClosing();
            }
        }
    }

    private void endOpening() {
        this.updateDividerLocation(1.0f);
        this.state = AnimatedSplitPaneState.OPEN;
        AnimatedSplitPaneEvent evt = new AnimatedSplitPaneEvent(this, this.state);
        this.fireAnimatedSplitPaneEvent(evt);
    }

    private void endClosing() {
        this.state = AnimatedSplitPaneState.CLOSED;
        if (this.hideRightOrBottomComponent) {
            if (this.getBottomComponent() != null) {
                this.getBottomComponent().setVisible(false);
            }
        } else if (this.getTopComponent() != null) {
            this.getTopComponent().setVisible(false);
        }
        this.setDividerSize(0);
        AnimatedSplitPaneEvent evt = new AnimatedSplitPaneEvent(this, this.state);
        this.fireAnimatedSplitPaneEvent(evt);
    }

    @Override
    public void repeat() {
    }

    @Override
    public void timingEvent(float fraction) {
        switch (this.state) {
            case CLOSING: 
            case OPENING: {
                this.updateDividerLocation(fraction);
            }
        }
    }

    private void updateDividerLocation(float fraction) {
        Component comp = this.getBottomComponent();
        if (!this.hideRightOrBottomComponent) {
            comp = this.getTopComponent();
        }
        Dimension dim = comp.getPreferredSize();
        int s2 = dim.height;
        if (this.getOrientation() == 1) {
            s2 = dim.width;
        }
        s2 = (int)((float)s2 * fraction);
        if (this.getOrientation() == 1) {
            if (this.hideRightOrBottomComponent) {
                this.setDividerLocation(this.getWidth() - s2);
            } else {
                this.setDividerLocation(s2);
            }
        } else if (this.hideRightOrBottomComponent) {
            this.setDividerLocation(this.getHeight() - s2);
        } else {
            this.setDividerLocation(s2);
        }
        AnimatedSplitPaneEvent evt = new AnimatedSplitPaneEvent(this, this.state);
        this.fireAnimatedSplitPaneEvent(evt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (this.state) {
            case CLOSED: 
            case CLOSING: 
            case OPENING: {
                break;
            }
            case OPEN: {
                if (!evt.getSource().equals(this) || !evt.getPropertyName().equals("dividerLocation")) break;
                this.updatePreferredSize(true);
            }
        }
    }

    public void updatePreferredSize(boolean basedOnActualSize) {
        Component comp = this.getRightComponent();
        if (!this.hideRightOrBottomComponent) {
            comp = this.getLeftComponent();
        }
        if (comp != null) {
            Dimension dim = comp.getPreferredSize();
            if (basedOnActualSize) {
                if (this.getOrientation() == 1) {
                    dim.width = comp.getWidth() + this.getDividerSize();
                } else {
                    dim.height = comp.getHeight() + this.getDividerSize();
                }
            } else if (this.getOrientation() == 1) {
                dim.width = this.getWidth() - this.getDividerLocation() + this.getDividerSize();
            } else {
                dim.height = this.getHeight() - this.getDividerLocation() + this.getDividerSize();
            }
            comp.setPreferredSize(dim);
        }
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(new BizLookAndFeel());
        JFrame f2 = new JFrame("Test");
        final AnimatedSplitPane split = new AnimatedSplitPane(true);
        split.setOrientation(0);
        split.addAnimatedSplitPaneListener(new IAnimatedSplitPaneListener(){

            @Override
            public void splitChanged(AnimatedSplitPaneEvent evt) {
                System.out.println(evt);
            }
        });
        f2.add(split);
        f2.setSize(500, 500);
        f2.setDefaultCloseOperation(3);
        JButton b2 = new JButton("Toggle");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                split.toggle();
            }
        });
        f2.add("South", b2);
        f2.setVisible(true);
    }
}

