/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.EmiratesPOC;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.AircraftGanttChartContentPanel;
import com.dlsc.emirates.swing.FlightsGanttChartContentPanel;
import com.dlsc.emirates.swing.IntroPage;
import com.dlsc.emirates.swing.MenuBar;
import com.dlsc.emirates.swing.SynchDemoContentPanel;
import com.dlsc.emirates.swing.View;
import com.dlsc.flexgantt.swing.util.InfiniteProgressPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class Workbench
extends JPanel {
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private Map<View, AbstractContentPanel> panelMap;
    private IntroPage introPage;
    private EmiratesPOC viewer;
    private View currentView;
    private ArrayList<View> views;
    private MenuBar menuBar;
    private InfiniteProgressPanel progressPanel;
    private ModelFactory modelFactory;

    public Workbench(EmiratesPOC viewer) {
        this.viewer = viewer;
        this.views = new ArrayList();
        this.views.add(new View("Aircrafts", View.Type.FLEET, "Fleet Schedule", "Flights Assigned to Aircraft"));
        this.views.add(new View("Synch Demo", View.Type.SYNCH_DEMO, "Synch Demo", "Synchronizing Several Gantt Charts"));
        this.setLayout(new BorderLayout());
        this.panelMap = new HashMap<View, AbstractContentPanel>();
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.introPage = new IntroPage(this);
        this.cardPanel.add("intro", this.introPage);
        this.add("Center", this.cardPanel);
        this.progressPanel = new InfiniteProgressPanel();
        viewer.getMainFrame().setGlassPane(this.progressPanel);
    }

    public ArrayList<View> getViews() {
        return this.views;
    }

    private JComponent createViewComponent(View view, InputStream stream) {
        switch (view.getType()) {
            case FLEET: {
                return this.createFleetView(view, stream);
            }
            case FLIGHTS: {
                return this.createFlightsView(view, stream);
            }
            case SYNCH_DEMO: {
                return this.createSynchDemo(view);
            }
        }
        return this.createUnknownView(view);
    }

    private JComponent createFleetView(View view, InputStream stream) {
        return new AircraftGanttChartContentPanel(this.modelFactory, this, view, stream);
    }

    private JComponent createFlightsView(View view, InputStream stream) {
        return new FlightsGanttChartContentPanel(this.modelFactory, this, view, stream);
    }

    private JComponent createSynchDemo(View view) {
        return new SynchDemoContentPanel(this.modelFactory, this, view);
    }

    private JComponent createUnknownView(View view) {
        return new JLabel("Unknown view type: " + (Object)((Object)view.getType()));
    }

    public void load(File file) throws FileNotFoundException {
        this.load(new FileInputStream(file), -1);
    }

    public void load(final InputStream stream, int numberOfFlightsInFile) {
        this.viewer.getMainFrame().setTitle("Emirates Proof Of Concept");
        this.introPage.beginTask("Loading data file...", numberOfFlightsInFile);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Workbench.this.modelFactory = new ModelFactory(stream, Workbench.this.introPage);
                Workbench.this.panelMap.clear();
                Workbench.this.cardPanel.removeAll();
                Workbench.this.cardPanel.add("intro", Workbench.this.introPage);
                int viewCount = Workbench.this.views.size();
                View initialView = null;
                for (int i2 = 0; i2 < viewCount; ++i2) {
                    View view = (View)Workbench.this.views.get(i2);
                    if (initialView == null) {
                        initialView = view;
                    }
                    JComponent comp = Workbench.this.createViewComponent(view, stream);
                    Workbench.this.cardPanel.add(view.getName().toString(), comp);
                    Workbench.this.panelMap.put(view, (AbstractContentPanel)comp);
                }
                return initialView;
            }

            @Override
            protected void done() {
                try {
                    View initialView = (View)this.get();
                    Workbench.this.showView(initialView);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public void showView(View view) {
        this.currentView = view;
        this.cardLayout.show(this.cardPanel, view.getName());
        AbstractContentPanel panel = this.panelMap.get(view);
        panel.activate();
        this.menuBar.setView(view);
    }

    public void showTitle() {
        this.currentView = null;
        this.cardLayout.show(this.cardPanel, "intro");
        this.menuBar.setView(null);
        this.introPage.hideProgressBar();
    }

    public AbstractContentPanel getCurrentContentPanel() {
        if (this.currentView != null) {
            AbstractContentPanel panel = this.panelMap.get(this.currentView);
            return panel;
        }
        return null;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public void setMenuBar(MenuBar bar) {
        this.menuBar = bar;
    }

    public void block(String text) {
        this.progressPanel.setText(text);
        this.progressPanel.start();
    }

    public void unblock() {
        this.progressPanel.stop();
    }

    public void export() throws Exception {
        AbstractContentPanel panel = this.panelMap.get(this.currentView);
        panel.export(true);
    }
}

