/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import java.awt.GridLayout;
import javax.swing.BoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScrollDemoPanel
extends JPanel
implements IDatelineModelListener {
    private GanttChart[] gantt = new GanttChart[4];
    private boolean processingEvent;

    public ScrollDemoPanel() {
        this.setLayout(new GridLayout(2, 2));
        for (int i2 = 0; i2 < this.gantt.length; ++i2) {
            this.gantt[i2] = new GanttChart();
            this.add(this.gantt[i2]);
            this.gantt[i2].setName("GC " + i2);
        }
        BoundedRangeModel scrollModel = this.gantt[0].getLayerContainerScrollPane().getHorizontalScrollBar().getModel();
        for (int i3 = 0; i3 < this.gantt.length; ++i3) {
            this.gantt[i3].getDateline().getModel().addDatelineModelListener(this);
            if (i3 <= 0) continue;
            this.gantt[i3].getLayerContainerScrollPane().getHorizontalScrollBar().setModel(scrollModel);
        }
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) throws DatelineModelVetoException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        System.out.println(evt);
        if (this.processingEvent) return;
        try {
            this.processingEvent = true;
            switch (evt.getId()) {
                case REQUESTED_VISIBLE_TIME_SPAN_CHANGED: {
                    this.adjustRequestedVisibleTimeSpan(evt);
                    return;
                }
                case GRANULARITY_CHANGED: {
                    this.adjustGranularity(evt);
                    return;
                }
                case SELECTED_TIME_SPAN_CHANGED: {
                    this.adjustSelectedTimeSpan(evt);
                    return;
                }
                case ZOOM_CHANGED: {
                    this.adjustZoom(evt);
                    return;
                }
                case TIME_SPAN_CHANGED: {
                    this.adjustTimeSpan(evt);
                    return;
                }
            }
            return;
        }
        catch (DatelineModelException e2) {
            e2.printStackTrace();
            return;
        }
        finally {
            this.processingEvent = false;
        }
    }

    private void adjustRequestedVisibleTimeSpan(DatelineModelEvent evt) throws DatelineModelException {
        ITimeSpan span = evt.getRequestedVisibleTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.requestVisibleTimeSpan(span);
        }
    }

    private void adjustTimeSpan(DatelineModelEvent evt) throws DatelineModelException {
        ITimeSpan span = evt.getModel().getTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setTimeSpan(span);
        }
    }

    private void adjustSelectedTimeSpan(DatelineModelEvent evt) {
        ITimeSpan span = evt.getModel().getSelectedTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setSelectedTimeSpan(span);
        }
    }

    private void adjustZoom(DatelineModelEvent evt) throws DatelineModelException {
        double zoom = evt.getModel().getZoom();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setZoom(zoom);
        }
    }

    private void adjustGranularity(DatelineModelEvent evt) throws DatelineModelException {
        TimeGranularity granularity = (TimeGranularity)evt.getModel().getGranularity();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setGranularity(granularity);
        }
    }

    public static void main(String[] args) {
        FlexGanttLicenseManager.setLicenseKey("LIC=DLSC;VEN=DLSC;VER=2;RUN=no;CTR=1;SignCode=1F;Signature=302D0215008F7E9DCB1A657E51E2FF09400388595003149C7B021448AC6616D5F09B8D822E14ECFD2BF52DE9A31B13");
        JFrame frame = new JFrame("Scroll Demo");
        frame.setSize(1200, 1000);
        frame.setDefaultCloseOperation(3);
        frame.add(new ScrollDemoPanel());
        frame.setVisible(true);
    }
}

