/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.EmiratesPOC;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.AircraftGanttChart;
import com.dlsc.emirates.swing.AircraftGanttChartContentPanel;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.flexgantt.swing.action.gantt.RedoActionLabeled;
import com.dlsc.flexgantt.swing.action.gantt.UndoActionLabeled;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.SingleFrameApplication;

public class MenuBar
extends JMenuBar {
    private static final int HISTORY_SIZE = 5;
    private JFileChooser chooser;
    private Workbench workbench;
    private JMenu fileMenu;
    private List<JMenuItem> historyItems;
    private JMenu editMenu;
    private JMenu viewMenu;

    public MenuBar(Workbench workbench) {
        this.workbench = workbench;
        this.historyItems = new ArrayList<JMenuItem>();
        this.createFileMenu();
        this.createEditMenu();
        this.createViewMenu();
    }

    private void createViewMenu() {
        this.viewMenu = new JMenu("View");
        JMenuItem showErrors = new JMenuItem("Show / Hide Warnings & Errors");
        showErrors.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        showErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractContentPanel contentPanel = MenuBar.this.workbench.getCurrentContentPanel();
                if (contentPanel != null && contentPanel instanceof AircraftGanttChartContentPanel) {
                    AircraftGanttChartContentPanel gcPanel = (AircraftGanttChartContentPanel)contentPanel;
                    if (gcPanel.isShowingErrors()) {
                        gcPanel.getSplitPane().close();
                    } else {
                        gcPanel.showErrors();
                    }
                }
            }
        });
        this.viewMenu.add(showErrors);
        this.add(this.viewMenu);
        this.viewMenu.setVisible(false);
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.add(this.fileMenu);
        JMenuItem openItem = new JMenuItem("Open...");
        openItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.fileMenu.add(openItem);
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                File file;
                if (MenuBar.this.chooser == null) {
                    MenuBar.this.chooser = new JFileChooser();
                    MenuBar.this.chooser.setPreferredSize(new Dimension(600, 500));
                    MenuBar.this.chooser.setDialogTitle("Open XML Data File");
                    MenuBar.this.chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f2) {
                            if (f2.isFile() && f2.getName().endsWith(".xml")) {
                                return true;
                            }
                            return f2.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "Emirates Flights File";
                        }
                    });
                }
                MenuBar.this.chooser.setMultiSelectionEnabled(false);
                if (MenuBar.this.chooser.showOpenDialog(MenuBar.this.workbench) == 0 && (file = MenuBar.this.chooser.getSelectedFile()) != null) {
                    try {
                        MenuBar.this.loadFile(file);
                        MenuBar.this.updateFrameTitle(file.getAbsolutePath());
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(MenuBar.this, "File not found!", "Error", 0);
                    }
                }
            }
        });
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MenuBar.this.workbench.showTitle();
            }
        });
        this.fileMenu.add(closeItem);
        this.fileMenu.addSeparator();
        JMenuItem clearHistory = new JMenuItem("Clear History");
        this.fileMenu.add(clearHistory);
        clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MenuBar.this.clearHistory();
            }
        });
        Preferences prefs = Preferences.userRoot();
        for (int i2 = 0; i2 < 5; ++i2) {
            final String file = prefs.get(this.createFileKey(i2), null);
            if (file == null) continue;
            JMenuItem item = new JMenuItem(this.createFileName(file));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        MenuBar.this.loadFile(file);
                        MenuBar.this.updateFrameTitle(file);
                    }
                    catch (FileNotFoundException e1) {
                        JOptionPane.showMessageDialog(MenuBar.this, "File not found!", "Error", 0);
                    }
                }
            });
            this.fileMenu.add(item);
            this.historyItems.add(item);
        }
        this.fileMenu.addSeparator();
        JMenuItem export = new JMenuItem("Export...");
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    MenuBar.this.workbench.export();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(MenuBar.this.workbench, "Error: " + e1.getMessage(), "Error", 0);
                }
            }
        });
        this.fileMenu.add(export);
        JMenuItem exitItem = new JMenuItem("Exit...");
        this.fileMenu.add(exitItem);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
    }

    private void updateFrameTitle(String fileName) {
        SingleFrameApplication app = (SingleFrameApplication)EmiratesPOC.getInstance();
        JFrame frame = app.getMainFrame();
        frame.setTitle("Emirates Proof of Concept - " + fileName);
    }

    private void loadFile(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.workbench, "File does not exist anymore!", "Error", 0);
        }
        this.loadFile(file);
    }

    private void loadFile(File file) throws FileNotFoundException {
        this.workbench.load(file);
        this.addFileToHistory(file.getAbsolutePath());
    }

    private void clearHistory() {
        Preferences prefs = Preferences.userRoot();
        for (int i2 = 0; i2 < 5; ++i2) {
            prefs.remove(this.createFileKey(i2));
        }
        for (JMenuItem item : this.historyItems) {
            this.fileMenu.remove(item);
        }
        this.historyItems.clear();
    }

    private void addFileToHistory(String fileName) {
        String file;
        int i2;
        Stack<String> stack = new Stack<String>();
        Preferences prefs = Preferences.userRoot();
        boolean duplicate = false;
        for (i2 = 0; i2 < 5; ++i2) {
            file = prefs.get(this.createFileKey(i2), null);
            if (file == null) continue;
            if (file.equals(fileName)) {
                duplicate = true;
                break;
            }
            stack.push(file);
        }
        if (!duplicate) {
            stack.push(fileName);
            for (i2 = 0; i2 < 5; ++i2) {
                if (stack.isEmpty() || (file = (String)stack.pop()) == null) continue;
                prefs.put(this.createFileKey(i2), file);
            }
        }
    }

    private String createFileKey(int index) {
        return "emirates-file-history-" + index;
    }

    private String createFileName(String name) {
        return name;
    }

    private void createEditMenu() {
        this.editMenu = new JMenu("Edit");
        this.add(this.editMenu);
        this.editMenu.setVisible(false);
    }

    public void setView(View view) {
        this.editMenu.removeAll();
        if (view != null && view.getType().equals((Object)View.Type.FLEET)) {
            AircraftGanttChartContentPanel contentPanel = (AircraftGanttChartContentPanel)this.workbench.getCurrentContentPanel();
            final AircraftGanttChart ganttChart = contentPanel.getGanttChart();
            UndoActionLabeled<AircraftGanttChart> undo = new UndoActionLabeled<AircraftGanttChart>(ganttChart);
            RedoActionLabeled<AircraftGanttChart> redo = new RedoActionLabeled<AircraftGanttChart>(ganttChart);
            this.editMenu.add(undo).setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.editMenu.add(redo).setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.editMenu.addSeparator();
            JMenuItem findItem = new JMenuItem("Find...");
            findItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            findItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ganttChart.showFindHUD();
                }
            });
            this.editMenu.add(findItem);
            this.viewMenu.setVisible(true);
        } else {
            this.viewMenu.setVisible(false);
        }
        this.editMenu.setVisible(this.editMenu.getMenuComponentCount() > 0);
    }
}

