/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.commands.CreateFlightCommand;
import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.AbstractEmiratesGanttChart;
import com.dlsc.emirates.swing.hud.SettingsHUD;
import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.TimelineObjectPathMessage;
import com.dlsc.flexgantt.swing.layer.DefaultLayerContainerMenuProvider;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class EmiratesMenuProvider
extends DefaultLayerContainerMenuProvider {
    static DataFlavor localObjectFlavor = new DataFlavor(OriginalFlight[].class, "Flight Data");
    private LayerContainer lc;
    private TreePath treePath;
    private long timeAtClickLocation;
    private List<OriginalFlight> copiedFlights;
    private ModelFactory modelFactory;
    private AbstractContentPanel contentPanel;

    public EmiratesMenuProvider(ModelFactory modelFactory, AbstractContentPanel contentPanel) {
        this.modelFactory = modelFactory;
        this.contentPanel = contentPanel;
    }

    @Override
    public JPopupMenu getPopupMenu(LayerContainer lc2, MouseEvent e2, long timePoint, TreePath treePath, TimelineObjectPath[] paths, IRelationship[] relationships) {
        this.lc = lc2;
        this.treePath = treePath;
        this.timeAtClickLocation = lc2.getDateline().getTimeAt(e2.getX());
        return super.getPopupMenu(lc2, e2, timePoint, treePath, paths, relationships);
    }

    @Override
    protected JMenuItem[] createMenuExtensions(boolean spreadsheet) {
        JMenuItem[] items = new JMenuItem[7];
        items[0] = new JMenuItem("Create Flight");
        items[0].setIcon(IconRegistry.getIcon(IconId.CREATE_TIMELINE_OBJECT));
        items[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EmiratesMenuProvider.this.createFlight();
            }
        });
        items[1] = new JMenuItem("Copy Flights");
        items[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EmiratesMenuProvider.this.copy();
            }
        });
        items[2] = new JMenuItem("Paste Flights");
        items[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EmiratesMenuProvider.this.paste();
            }
        });
        items[3] = new JMenuItem("Mark for follow-up");
        items[3].setIcon(IconRegistry.getIcon(IconId.WARNING));
        items[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EmiratesMenuProvider.this.markForFollowUp();
            }
        });
        items[4] = new JMenuItem("Mark as invalid");
        items[4].setIcon(IconRegistry.getIcon(IconId.ERROR));
        items[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                EmiratesMenuProvider.this.markAsInvalid();
            }
        });
        DefaultGanttChartNode node = (DefaultGanttChartNode)this.treePath.getLastPathComponent();
        items[5] = new JMenu("Move to line");
        int lineCount = node.getLineCount();
        items[5].setEnabled(lineCount > 1);
        if (lineCount > 1) {
            for (int i2 = 1; i2 <= node.getLineCount(); ++i2) {
                JMenuItem item = new JMenuItem("Line " + i2);
                items[5].add(item);
                final int lineIndex = i2 - 1;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        EmiratesMenuProvider.this.addToLine(lineIndex);
                    }
                });
            }
        }
        items[6] = new JMenuItem("Export Flights...");
        items[6].setIcon(IconRegistry.getIcon(IconId.FOLDER_OPEN));
        items[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    EmiratesMenuProvider.this.contentPanel.export(false);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(EmiratesMenuProvider.this.contentPanel, "Error when exporting: " + e1.getMessage(), "Error", 0);
                    e1.printStackTrace();
                }
            }
        });
        return items;
    }

    private void createFlight() {
        CreateFlightCommand cmd = new CreateFlightCommand(this.modelFactory, this.treePath, this.timeAtClickLocation);
        this.lc.getGanttChart().commandExecute(cmd);
    }

    protected void markAsInvalid() {
        this.setStatus("invalid");
    }

    private void markForFollowUp() {
        this.setStatus("follow-up");
    }

    private void setStatus(String status) {
        String comment = JOptionPane.showInputDialog(SwingUtilities.getWindowAncestor(this.lc), (Object)"Enter comment for marker:");
        if (comment != null) {
            List<TimelineObjectPath> paths = this.lc.getSelectedTimelineObjects();
            for (TimelineObjectPath path : paths) {
                if (!(path.getTimelineObject() instanceof FlightTimelineObject)) continue;
                FlightTimelineObject tlo = (FlightTimelineObject)path.getTimelineObject();
                tlo.setStatus(status);
                TimelineObjectPathMessage msg = null;
                String prefix = "Flight " + ((ROW)tlo.getUserObject()).getFLIGHTNO() + " on " + ((ROW)tlo.getUserObject()).getFLIGHTDATE() + ": ";
                if (status.equals("follow-up")) {
                    msg = new TimelineObjectPathMessage(MessageTypeId.WARNING, prefix + comment, path);
                } else if (status.equals("invalid")) {
                    msg = new TimelineObjectPathMessage(MessageTypeId.ERROR, prefix + comment, path);
                }
                if (msg == null) continue;
                this.lc.getGanttChart().addMessage(msg);
            }
        }
        this.lc.repaint();
    }

    private void addToLine(int lineIndex) {
        List<TimelineObjectPath> paths = this.lc.getSelectedTimelineObjects();
        for (TimelineObjectPath path : paths) {
            if (!(path.getTimelineObject() instanceof FlightTimelineObject)) continue;
            FlightTimelineObject tlo = (FlightTimelineObject)path.getTimelineObject();
            tlo.setLineIndex(lineIndex);
            AircraftGanttChartNode node = (AircraftGanttChartNode)path.getLastPathComponent();
            node.setLineCount(Math.max(node.getLineCount(), lineIndex + 1));
            node.setRowHeight(node.getLineCount() * 36);
            List flights = node.getTimelineObjects();
            for (FlightTimelineObject f2 : flights) {
                if (f2.getLineIndex() != -1) continue;
                f2.setLineIndex(0);
            }
        }
        this.lc.getGanttChart().repaint();
    }

    private void copy() {
        List<TimelineObjectPath> paths = this.lc.getSelectedTimelineObjects();
        this.copiedFlights = new ArrayList<OriginalFlight>();
        for (TimelineObjectPath p2 : paths) {
            if (!(p2.getTimelineObject() instanceof FlightTimelineObject)) continue;
            FlightTimelineObject flight = (FlightTimelineObject)p2.getTimelineObject();
            this.copiedFlights.add(new OriginalFlight((ROW)flight.getUserObject(), p2.getLayer(), flight.getTimeSpan()));
        }
    }

    private void paste() {
        if (this.treePath.getLastPathComponent() instanceof AircraftGanttChartNode) {
            final AircraftGanttChartNode acNode = (AircraftGanttChartNode)this.treePath.getLastPathComponent();
            if (this.copiedFlights != null) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        long earliestTime = Long.MAX_VALUE;
                        for (OriginalFlight flight : EmiratesMenuProvider.this.copiedFlights) {
                            earliestTime = Math.min(earliestTime, flight.getTimeSpan().getStartTime());
                        }
                        final long delta = EmiratesMenuProvider.this.timeAtClickLocation - earliestTime;
                        for (final OriginalFlight flight : EmiratesMenuProvider.this.copiedFlights) {
                            AbstractCommand cmd = new AbstractCommand("Paste Flights"){
                                private List<TimelineObjectPath<FlightTimelineObject>> paths;
                                {
                                    super(x0);
                                    this.paths = new ArrayList<TimelineObjectPath<FlightTimelineObject>>();
                                }

                                @Override
                                public void executeCommand(IProgressMonitor monitor) throws CommandException {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            FlightTimelineObject tlo = new FlightTimelineObject(flight.getRow());
                                            ITimeSpan span = flight.getTimeSpan();
                                            tlo.setTimeSpan(new TimeSpan(span.getStartTime() + delta, span.getEndTime() + delta));
                                            acNode.addTimelineObject(flight.getLayer(), tlo);
                                            paths.add(new TimelineObjectPath<FlightTimelineObject>(acNode.getPath(), tlo, flight.getLayer()));
                                            DefaultGanttChartModel model = (DefaultGanttChartModel)EmiratesMenuProvider.this.lc.getModel();
                                            acNode.calculateLines();
                                            model.nodeStructureChanged(acNode);
                                        }
                                    });
                                }

                                @Override
                                public void undoCommand(IProgressMonitor monitor) throws CommandException {
                                    for (TimelineObjectPath<FlightTimelineObject> path : this.paths) {
                                        acNode.removeTimelineObject(path.getLayer(), (ITimelineObject)path.getTimelineObject());
                                    }
                                    DefaultGanttChartModel model = (DefaultGanttChartModel)EmiratesMenuProvider.this.lc.getModel();
                                    acNode.calculateLines();
                                    model.nodeStructureChanged(acNode);
                                }
                            };
                            AbstractEmiratesGanttChart ganttChart = (AbstractEmiratesGanttChart)EmiratesMenuProvider.this.lc.getGanttChart();
                            ganttChart.commandExecute(cmd);
                            if (EmiratesMenuProvider.this.copiedFlights.size() >= 20 || !SettingsHUD.delayPastingFlights.isSelected()) continue;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                };
                thread.start();
            }
        }
    }

    class OriginalFlight
    implements Serializable {
        private ROW row;
        private ITimeSpan timeSpan;
        private ILayer layer;

        public OriginalFlight(ROW row, ILayer layer, ITimeSpan timeSpan) {
            this.row = row;
            this.timeSpan = timeSpan;
            this.layer = layer;
        }

        public ROW getRow() {
            return this.row;
        }

        public ITimeSpan getTimeSpan() {
            return this.timeSpan;
        }

        public ILayer getLayer() {
            return this.layer;
        }
    }
}

