/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.swing.IntroPage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.ImagePainter;

public class BackdropPanel
extends JXPanel
implements Runnable {
    private List<Bar> bars = new ArrayList<Bar>();
    private boolean running = true;

    public BackdropPanel() {
        try {
            BufferedImage image = ImageIO.read(IntroPage.class.getResource("cover.jpg"));
            ImagePainter painter = new ImagePainter(image);
            painter.setFillHorizontal(true);
            painter.setFillVertical(true);
            this.setBackgroundPainter(painter);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.bars.add(new Bar(-40, 60, 3, 0.5f));
        this.bars.add(new Bar(80, 200, 2, 0.2f));
        this.bars.add(new Bar(800, 50, -4, 0.4f));
        this.bars.add(new Bar(250, 60, -1, 0.1f));
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopAnimation() {
        this.running = false;
        this.repaint();
    }

    @Override
    public void run() {
        while (this.running) {
            this.repaint();
            try {
                Thread.sleep(50L);
                for (Bar bar : this.bars) {
                    bar.update();
                }
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.running) {
            Graphics2D g2d = (Graphics2D)g2.create();
            for (Bar bar : this.bars) {
                g2d.setColor(Color.WHITE);
                g2d.setComposite(AlphaComposite.getInstance(3, bar.opacity));
                g2d.fillRect(0, bar.y, this.getWidth(), bar.width);
            }
            g2d.dispose();
        }
    }

    class Bar {
        int y;
        int velocity = 1;
        int width;
        float opacity;

        public Bar(int y2, int width, int velocity, float opacity) {
            this.y = y2;
            this.width = width;
            this.velocity = velocity;
            this.opacity = opacity;
        }

        public void update() {
            this.y += this.velocity;
            if (this.y > BackdropPanel.this.getHeight() + 100 && this.velocity > 0 || this.y < -100 && this.velocity < 0) {
                this.velocity = -this.velocity;
            }
        }
    }
}

