/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.model.TailGroupGanttChartNode;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.AircraftGanttChart;
import com.dlsc.emirates.swing.EmiratesMenuProvider;
import com.dlsc.emirates.swing.ToolBar;
import com.dlsc.emirates.swing.Utils;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.emirates.swing.hud.SettingsHUD;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineObject;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.GanttChartStatusBar;
import com.dlsc.flexgantt.swing.MessageTable;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectSelectionListener;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectSelectionEvent;
import com.dlsc.flexgantt.swing.timeline.Eventline;
import com.dlsc.flexgantt.swing.treetable.INodeFilter;
import com.opencsv.CSVWriter;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.CardLayout;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AircraftGanttChartContentPanel
extends AbstractContentPanel
implements ITimelineObjectSelectionListener,
TreeSelectionListener,
IGanttChartModelListener {
    private static final long serialVersionUID = 1L;
    private AircraftGanttChart ganttChart;
    private JPanel drawerCardPanel;
    private CardLayout drawerLayout;
    private MessageTable table;
    private Map<String, AircraftGanttChartNode> aircraftMap = new HashMap<String, AircraftGanttChartNode>();
    private List<SelectionMarker> markers = new ArrayList<SelectionMarker>();
    private ModelFactory modelFactory;
    private FileDialog exportFileDialog;

    public AircraftGanttChartContentPanel(ModelFactory modelFactory, Workbench workbench, View view, InputStream stream) {
        super(workbench, view);
        this.modelFactory = modelFactory;
        this.getHeader().getSecondaryHeaderLabel().setText(this.getHeader().getSecondaryHeaderLabel().getText() + " / " + modelFactory.getTotalNumberOfPlanes() + " Resources / " + modelFactory.getTotalNumberOfFlights() + " Flights");
        this.ganttChart.setModelFactory(modelFactory);
        this.ganttChart.setModel(modelFactory.getFleetModel());
        this.ganttChart.setSecondaryModel(modelFactory.getAlternativeAircraftModel());
        this.ganttChart.setTimeSpan(modelFactory.getHorizon());
        this.ganttChart.getPrimaryLayerContainer().getTimelineObjectLayer(ModelFactory.USAGE_LAYER).setAlpha(0.8f);
        this.ganttChart.getPrimaryTreeTable().getSelectionModel().addTreeSelectionListener(this);
        this.ganttChart.getPrimaryLayerContainer().setMenuProvider(new EmiratesMenuProvider(modelFactory, this));
        this.ganttChart.getModel().addGanttChartModelListener(this);
        this.ganttChart.getSecondaryModel().addGanttChartModelListener(this);
        LayerContainer lc2 = this.ganttChart.getPrimaryLayerContainer();
        for (ILayer layer : lc2.getLayers()) {
            lc2.getSelectionModel(layer).addTimelineObjectSelectionModelListener(this);
        }
    }

    public AircraftGanttChart getGanttChart() {
        return this.ganttChart;
    }

    @Override
    public void activate() {
        this.ganttChart.expandAll();
        this.ganttChart.optimizeColumnWidth();
        this.ganttChart.resetToPreferredSizes();
    }

    @Override
    protected JComponent createContent() {
        this.ganttChart = new AircraftGanttChart(this.getView());
        return this.ganttChart;
    }

    @Override
    protected JComponent createDrawer() {
        this.drawerCardPanel = new JPanel();
        this.drawerLayout = new CardLayout();
        this.drawerCardPanel.setLayout(this.drawerLayout);
        this.table = new MessageTable(this.ganttChart, new MessageTableModel(this.ganttChart));
        this.table.setShowGrid(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.drawerCardPanel.add("errors", scrollPane);
        return this.drawerCardPanel;
    }

    public boolean isShowingErrors() {
        return this.getSplitPane().isOpen() && this.table.isShowing();
    }

    public void showMap() {
        this.drawerLayout.show(this.drawerCardPanel, "map");
        if (!this.getSplitPane().isOpen()) {
            this.getSplitPane().open();
        }
    }

    public void showErrors() {
        this.drawerLayout.show(this.drawerCardPanel, "errors");
        if (!this.getSplitPane().isOpen()) {
            this.getSplitPane().open();
        }
    }

    @Override
    protected JComponent createToolBar() {
        ToolBar toolBar = new ToolBar(this.ganttChart);
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        return toolBar;
    }

    @Override
    protected StatusBar createStatusBar() {
        GanttChartStatusBar<AircraftGanttChart> statusBar = new GanttChartStatusBar<AircraftGanttChart>(this.ganttChart);
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        Utils.makeLabelsShadowed(statusBar);
        return statusBar;
    }

    @Override
    public void setSearchText(final String text) {
        this.ganttChart.getPrimaryTreeTable().setNodeFilter(new INodeFilter(){

            @Override
            public boolean includeNode(Object node) {
                if (node instanceof AircraftGanttChartNode) {
                    return this.includePlane(node);
                }
                if (node instanceof TailGroupGanttChartNode) {
                    TailGroupGanttChartNode tailGroupNode = (TailGroupGanttChartNode)node;
                    for (int index = 0; index < tailGroupNode.getChildCount(); ++index) {
                        if (!this.includePlane(tailGroupNode.getChildAt(index))) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            private boolean includePlane(Object node) {
                AircraftGanttChartNode gcNode = (AircraftGanttChartNode)node;
                String name = (String)gcNode.getKey();
                return name.contains(text);
            }
        });
    }

    @Override
    public void valueChanged(TimelineObjectSelectionEvent evt) {
        if (evt.getId().equals((Object)TimelineObjectSelectionEvent.ID.TIMELINE_OBJECTS_ADDED)) {
            this.createSelectionMarkers(evt);
            this.showAlternativeAircrafts(evt);
        }
    }

    private void showAlternativeAircrafts(TimelineObjectSelectionEvent evt) {
        Object node = evt.getTimelineObjectPaths().get(0).getNode();
        if (node instanceof AircraftGanttChartNode) {
            AircraftGanttChartNode aircraftNode = (AircraftGanttChartNode)node;
            this.showAlternativeAircraftsForGivenNode(aircraftNode);
        }
    }

    private void showAlternativeAircraftsForGivenNode(AircraftGanttChartNode sourceNode) {
        TailGroupGanttChartNode groupNode = (TailGroupGanttChartNode)sourceNode.getParent();
        DefaultGanttChartNode root = (DefaultGanttChartNode)this.ganttChart.getSecondaryModel().getRoot();
        root.removeAllChildren();
        for (int index = 0; index < groupNode.getChildCount(); ++index) {
            AircraftGanttChartNode child = (AircraftGanttChartNode)groupNode.getChildAt(index);
            if (child.equals(sourceNode)) continue;
            AircraftGanttChartNode copiedChild = new AircraftGanttChartNode((ROW)child.getTypedUserObject());
            this.aircraftMap.put(((ROW)copiedChild.getTypedUserObject()).getResource(), copiedChild);
            for (ILayer layer : this.ganttChart.getPrimaryLayerContainer().getLayers()) {
                copiedChild.setTimelineObjects(layer, child.getTimelineObjects(layer));
            }
            if (SettingsHUD.showOverlappingFlights.isSelected()) {
                copiedChild.calculateLines();
            }
            root.add(copiedChild);
        }
        DefaultGanttChartModel model = (DefaultGanttChartModel)this.ganttChart.getSecondaryModel();
        model.nodeStructureChanged((TreeNode)model.getRoot());
    }

    private void createSelectionMarkers(TimelineObjectSelectionEvent evt) {
        Object object;
        Eventline eventline = this.ganttChart.getEventline();
        eventline.getModel().removeEventlineObjects(this.markers);
        if (evt.getTimelineObjectPaths().size() == 1 && SettingsHUD.showSelectionLines.isSelected() && (object = evt.getTimelineObjectPaths().get(0).getTimelineObject()) instanceof FlightTimelineObject) {
            FlightTimelineObject tlo = (FlightTimelineObject)object;
            ITimeSpan span = tlo.getTimeSpan();
            this.markers.clear();
            this.markers.add(new SelectionMarker("ST", new TimeSpan(span.getStartTime())));
            this.markers.add(new SelectionMarker("ET", new TimeSpan(span.getEndTime())));
            eventline.getModel().addEventlineObjects(this.markers);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        if (path.getLastPathComponent() instanceof AircraftGanttChartNode) {
            this.showAlternativeAircraftsForGivenNode((AircraftGanttChartNode)path.getLastPathComponent());
        }
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        switch (evt.getId()) {
            case TIMELINE_OBJECTS_ADDED: 
            case TIMELINE_OBJECTS_REMOVED: {
                AircraftGanttChartNode node;
                if (!(evt.getNode() instanceof AircraftGanttChartNode) || (node = (AircraftGanttChartNode)evt.getNode()) == null) break;
                node.calculateLines();
                if (!evt.getModel().equals(this.ganttChart.getModel())) break;
                DefaultGanttChartModel model = (DefaultGanttChartModel)this.ganttChart.getModel();
                model.nodeStructureChanged((TreeNode)model.getRoot());
                break;
            }
            case TIMELINE_OBJECT_CHANGED: {
                FlightTimelineObject tlo = (FlightTimelineObject)evt.getTimelineObject();
                DefaultGanttChartModel model = (DefaultGanttChartModel)this.ganttChart.getModel();
                if (evt.getModel().equals(model)) {
                    AircraftGanttChartNode aircraftNode = this.ganttChart.getModelFactory().getAircraftNodeForFlight(tlo);
                    aircraftNode.calculateLines();
                    model.nodeStructureChanged((TreeNode)model.getRoot());
                    break;
                }
                AircraftGanttChartNode aircraftNode = this.aircraftMap.get(((ROW)tlo.getUserObject()).getResource());
                if (aircraftNode == null) break;
                aircraftNode.calculateLines();
                ((DefaultGanttChartModel)this.ganttChart.getSecondaryModel()).nodeStructureChanged((TreeNode)model.getRoot());
            }
        }
    }

    @Override
    public void export(boolean all) throws Exception {
        if (this.exportFileDialog == null) {
            this.exportFileDialog = new FileDialog((JFrame)SwingUtilities.getWindowAncestor(this));
            this.exportFileDialog.setDirectory(System.getProperty("user.home"));
            this.exportFileDialog.setMode(1);
        }
        if (all) {
            this.exportFileDialog.setFile("export-all.csv");
        } else {
            this.exportFileDialog.setFile("export-selection.csv");
        }
        this.exportFileDialog.setVisible(true);
        String fileName = this.exportFileDialog.getFile();
        if (fileName != null) {
            File file = new File(this.exportFileDialog.getDirectory(), fileName);
            if (file.exists()) {
                if (JOptionPane.showConfirmDialog(this, "File exists. Delete?", "Warning", 0) == 0) {
                    file.delete();
                } else {
                    return;
                }
            }
            file.createNewFile();
            boolean success = true;
            try (CSVWriter writer = new CSVWriter(new FileWriter(file));){
                if (all) {
                    this.modelFactory.export(writer);
                } else {
                    FlightTimelineObject flight;
                    Object obj;
                    for (TimelineObjectPath path : this.ganttChart.getPrimaryLayerContainer().getSelectedTimelineObjects()) {
                        obj = path.getTimelineObject();
                        if (!(obj instanceof FlightTimelineObject)) continue;
                        flight = (FlightTimelineObject)obj;
                        flight.export(writer);
                    }
                    for (TimelineObjectPath path : this.ganttChart.getSecondaryLayerContainer().getSelectedTimelineObjects()) {
                        obj = path.getTimelineObject();
                        if (!(obj instanceof FlightTimelineObject)) continue;
                        flight = (FlightTimelineObject)obj;
                        flight.export(writer);
                    }
                }
            }
            if (success) {
                Desktop.getDesktop().open(file);
            }
        }
    }

    class SelectionMarker
    extends DefaultEventlineObject<Object> {
        public SelectionMarker(String name, ITimeSpan timeSpan) {
            super(name, timeSpan);
        }
    }
}

