/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.commands.CreateFlightCommand;
import com.dlsc.emirates.commands.CreateLegOrRouteRelationshipCommand;
import com.dlsc.emirates.commands.LegRouteInterceptor;
import com.dlsc.emirates.commands.ServiceTypeInterceptor;
import com.dlsc.emirates.model.AircraftColumnModel;
import com.dlsc.emirates.model.AircraftGanttChartNode;
import com.dlsc.emirates.model.TailGroupGanttChartNode;
import com.dlsc.emirates.swing.AbstractEmiratesGanttChart;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.hud.SettingsHUD;
import com.dlsc.emirates.swing.policy.EmiratesRelationshipPolicy;
import com.dlsc.emirates.swing.renderer.EmiratesCapacityObjectRenderer;
import com.dlsc.emirates.swing.renderer.EmiratesRowRenderer;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import com.dlsc.flexgantt.util.GridLineMode;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class AircraftGanttChart
extends AbstractEmiratesGanttChart {
    private static final long serialVersionUID = 1L;
    private SettingsHUD settings;

    public AircraftGanttChart(View view) {
        AircraftColumnModel colModel = new AircraftColumnModel();
        this.setColumnModel(colModel);
        for (LayerContainer layerContainer : this.getLayerContainers()) {
            IPolicyProvider layerContainerPolicyProvider = layerContainer.getPolicyProvider();
            EmiratesRelationshipPolicy rp = new EmiratesRelationshipPolicy();
            layerContainerPolicyProvider.setPolicy(IRelationshipPolicy.class, rp);
            layerContainer.getSystemLayer(RowLayer.class).setRowRenderer(AircraftGanttChartNode.class, new EmiratesRowRenderer());
            layerContainer.setTimelineObjectRenderer(DefaultCapacityObject.class, new EmiratesCapacityObjectRenderer());
        }
        for (JComponent jComponent : this.getLayerContainerScrollPanes()) {
            ((JScrollPane)jComponent).getRowHeader().setVisible(true);
        }
        this.setGridLineMode(GridLineMode.COMBINED_GRID_LINES);
        this.getDateline().setGranularity(TimeGranularity.SIX_HOURS);
        this.setCommandInterceptor(CreateLegOrRouteRelationshipCommand.class, new LegRouteInterceptor());
        this.setCommandInterceptor(CreateFlightCommand.class, new ServiceTypeInterceptor());
    }

    @Override
    public void showOverlappingFlights(boolean selected) {
        DefaultGanttChartModel model = (DefaultGanttChartModel)this.getModel();
        DefaultGanttChartNode root = (DefaultGanttChartNode)model.getRoot();
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TailGroupGanttChartNode group = (TailGroupGanttChartNode)root.getChildAt(i2);
            for (int j2 = 0; j2 < group.getChildCount(); ++j2) {
                AircraftGanttChartNode acNode = (AircraftGanttChartNode)group.getChildAt(j2);
                acNode.showOverlappingFlights(selected);
            }
        }
        this.getPrimaryTreeTable().updateNodes();
    }

    @Override
    public void showSettingsHUD() {
        if (this.settings == null) {
            this.settings = new SettingsHUD(this);
        }
        this.settings.getJDialog().setVisible(true);
    }
}

