/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.model.AircraftColumnModel;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.LegRelationship;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.model.RouteRelationship;
import com.dlsc.emirates.model.UAEHolidaysEventlineModel;
import com.dlsc.emirates.swing.EmiratesComponentFactory;
import com.dlsc.emirates.swing.LegsPathCalculator;
import com.dlsc.emirates.swing.RoutesPathCalculator;
import com.dlsc.emirates.swing.hud.FindHUD;
import com.dlsc.emirates.swing.policy.EmiratesGranularityZoomPolicy;
import com.dlsc.emirates.swing.policy.EmiratesRelationshipPolicy;
import com.dlsc.emirates.swing.renderer.EmiratesTreeTableCellRenderer;
import com.dlsc.emirates.swing.renderer.FlightTimelineObjectRenderer;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.policy.layer.IRelationshipPolicy;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DefaultPopupRenderer;
import com.dlsc.flexgantt.swing.layer.system.DefaultRelationshipRenderer;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.EventlineLayer;
import com.dlsc.flexgantt.swing.layer.system.PopupLayer;
import com.dlsc.flexgantt.swing.layer.system.RelationshipLayer;
import com.dlsc.flexgantt.swing.mac.MacTreeTableRowHeaderRenderer;
import com.dlsc.flexgantt.swing.print.PrintSetup;
import com.dlsc.flexgantt.swing.treetable.DefaultTreeTableRowHeaderRenderer;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class AbstractEmiratesGanttChart
extends DualGanttChart {
    private String searchTerm;
    private FindHUD findDialog;
    private ModelFactory modelFactory;

    public AbstractEmiratesGanttChart() {
        super(EmiratesComponentFactory.getInstance());
        AircraftColumnModel colModel = new AircraftColumnModel();
        this.setColumnModel(colModel);
        this.getPrimaryTreeTable().setCellRenderer(Object.class, new EmiratesTreeTableCellRenderer());
        this.getSecondaryTreeTable().setCellRenderer(Object.class, new EmiratesTreeTableCellRenderer());
        this.getPrimaryTreeTableRowHeader().setRowHeaderRenderer(Object.class, new MacTreeTableRowHeaderRenderer(DefaultTreeTableRowHeaderRenderer.Type.ROW_NUMBER));
        this.getPrimaryLayerContainer().setTimelineObjectRenderer(FlightTimelineObject.class, new FlightTimelineObjectRenderer());
        this.getSecondaryLayerContainer().setTimelineObjectRenderer(FlightTimelineObject.class, new FlightTimelineObjectRenderer());
        DefaultPopupRenderer popupRenderer = new DefaultPopupRenderer();
        popupRenderer.getTitleLabel().setFont(popupRenderer.getFont().deriveFont(1));
        popupRenderer.getTextArea().setFont(new Font("Monospaced", 0, 12));
        IPolicyProvider datelinePolicyProvider = this.getDateline().getPolicyProvider();
        EmiratesGranularityZoomPolicy dp = new EmiratesGranularityZoomPolicy();
        datelinePolicyProvider.setPolicy(IZoomPolicy.class, dp);
        PrintSetup ps = new PrintSetup();
        try {
            ps.setTitle("Fleet Schedule");
            ps.setLogo(ImageIO.read(AbstractEmiratesGanttChart.class.getResource("logo-emirates.gif")));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.setPrintSetup(ps);
        for (LayerContainer layerContainer : this.getLayerContainers()) {
            IPolicyProvider layerContainerPolicyProvider = layerContainer.getPolicyProvider();
            EmiratesRelationshipPolicy rp = new EmiratesRelationshipPolicy();
            layerContainerPolicyProvider.setPolicy(IRelationshipPolicy.class, rp);
            DefaultRelationshipRenderer legRenderer = new DefaultRelationshipRenderer(new LegsPathCalculator());
            legRenderer.setArrowSize(0);
            DefaultRelationshipRenderer routeRenderer = new DefaultRelationshipRenderer(new RoutesPathCalculator());
            routeRenderer.setArrowSize(0);
            RelationshipLayer relationshipLayer = layerContainer.getSystemLayer(RelationshipLayer.class);
            relationshipLayer.setRelationshipRenderer(LegRelationship.class, legRenderer);
            relationshipLayer.setRelationshipRenderer(RouteRelationship.class, routeRenderer);
            layerContainer.setHighlightingDuration(5000L);
            layerContainer.getSystemLayer(EventlineLayer.class).setPaintingEvents(true);
            PopupLayer popupLayer = this.getPrimaryLayerContainer().getSystemLayer(PopupLayer.class);
            popupLayer.setPopupRenderer(String.class, popupRenderer);
            DragLayer dragLayer = layerContainer.getSystemLayer(DragLayer.class);
            dragLayer.setShowingDefaultCursors(false);
        }
        for (JComponent jComponent : this.getLayerContainerScrollPanes()) {
            ((JScrollPane)jComponent).getRowHeader().setVisible(true);
        }
        this.getPrimaryTreeTable().setBackground(new Color(240, 250, 240));
        this.getPrimaryTreeTable().setAlternatingBackground(new Color(250, 255, 250));
        this.getPrimaryLayerContainer().setBackground(new Color(240, 250, 240));
        this.getPrimaryLayerContainer().setAlternatingBackground(new Color(250, 255, 250));
        this.getSecondaryTreeTable().setBackground(new Color(250, 240, 240));
        this.getSecondaryTreeTable().setAlternatingBackground(new Color(255, 250, 250));
        this.getSecondaryLayerContainer().setBackground(new Color(250, 240, 240));
        this.getSecondaryLayerContainer().setAlternatingBackground(new Color(255, 250, 250));
        this.getEventline().setModel(new UAEHolidaysEventlineModel());
        this.setPopupVisible(false);
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
        this.setPagingModel(modelFactory.getPagingModel());
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public String getTitle() {
        return "undefined";
    }

    public void showSettingsHUD() {
    }

    public void showOverlappingFlights(boolean selected) {
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String term) {
        this.searchTerm = term;
        this.getPrimaryLayerContainer().repaint();
        this.getSecondaryLayerContainer().repaint();
    }

    public void showFindHUD() {
        if (this.findDialog == null) {
            this.findDialog = new FindHUD(this);
        }
        this.findDialog.getJDialog().setVisible(true);
    }
}

