/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.model;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.opencsv.CSVWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FlightTimelineObject
extends DefaultTimelineObject<ROW> {
    private static final DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
    public static final String INVALID = "invalid";
    public static final String FOLLOW_UP = "follow-up";

    public FlightTimelineObject(ROW flight) {
        super(flight.getFLIGHTNO());
        this.setUserObject(flight);
    }

    @Override
    public Object getPopupTitleObject() {
        return "Flight ID: " + ((ROW)this.getUserObject()).getFLIGHTID();
    }

    @Override
    public Object getPopupObject(boolean extended) {
        if (extended) {
            return this;
        }
        String nl = System.getProperty("line.separator");
        ROW row = (ROW)this.getUserObject();
        StringBuilder sb2 = new StringBuilder();
        sb2.append(nl);
        sb2.append("Flight No.    : ");
        sb2.append(row.getFLIGHTNO());
        sb2.append(nl);
        sb2.append("Flight Date   : ");
        sb2.append(row.getFLIGHTDATE());
        sb2.append(nl);
        String startTime = dateFormat.format(new Date(this.getTimeSpan().getStartTime()));
        String endTime = dateFormat.format(new Date(this.getTimeSpan().getEndTime()));
        sb2.append("Leaving from  : ");
        sb2.append(row.getDEPARTURESTATION());
        sb2.append(" at ");
        sb2.append(startTime);
        sb2.append(nl);
        sb2.append("Arriving at   : ");
        sb2.append(row.getARRIVALSTATION());
        sb2.append(" at ");
        sb2.append(endTime);
        sb2.append(nl);
        sb2.append("Aircraft Type : ");
        sb2.append(row.getACTYPE());
        sb2.append(nl);
        sb2.append("Airline Code  : ");
        sb2.append(row.getAIRLINECODE());
        sb2.append(nl);
        sb2.append("Leg Number    : ");
        sb2.append(row.getLEGSEQNO());
        sb2.append(nl);
        sb2.append("Flight Type   : ");
        sb2.append(row.getFLTTYPE());
        sb2.append(nl);
        sb2.append("Service Type  : ");
        sb2.append(row.getSERVICETYPE());
        sb2.append(nl);
        sb2.append("Line          : ");
        sb2.append(this.getLineIndex());
        sb2.append(nl);
        return sb2.toString();
    }

    public void export(CSVWriter writer) {
        ROW row = (ROW)this.getUserObject();
        String[] str = new String[]{row.getFLIGHTID(), row.getFLIGHTDATE(), row.getResource(), row.getDEPARTURESTATION(), row.getARRIVALSTATION(), row.getSERVICETYPE(), Short.toString(row.getLEGSEQNO()), row.getREMARKS()};
        writer.writeNext(str);
    }
}

